--- ./bgpd/rde_update.c.dist	Wed Jan 10 08:56:49 2007
+++ ./bgpd/rde_update.c	Tue Jan  9 20:12:27 2007
@@ -284,7 +284,7 @@
 	}
 
 	if (peer->conf.ebgp && !aspath_loopfree(p->aspath->aspath,
-	    peer->conf.remote_as)) {
+						peer->conf.remote_as, 4)) {
 		/*
 		 * Do not send routes back to sender which would
 		 * cause an aspath loop.
@@ -465,7 +465,7 @@
 		return;
 
 	asp = path_get();
-	asp->aspath = aspath_get(NULL, 0);
+	asp->aspath = aspath_get(NULL, 0, 4);
 	asp->origin = ORIGIN_IGP;
 	/* the other default values are OK, nexthop is once again NULL */
 
@@ -626,6 +626,7 @@
 	int		 r, ismp = 0;
 	u_int16_t	 len = sizeof(up_attr_buf), wlen = 0;
 	u_int8_t	 l;
+        struct aspath   *oasp;
 
 	/* origin */
 	if ((r = attr_write(up_attr_buf + wlen, len, ATTR_WELL_KNOWN,
@@ -640,7 +641,20 @@
 	else
 		path = aspath_prepend(a->aspath, rde_local_as(), 1);
 
+        if (!(peer->capa_received.as_4bytes)) {
+                if ((oasp = aspath_convert(path)) == NULL) 
+                        return(-1) ;  
+
 	if ((r = attr_write(up_attr_buf + wlen, len, ATTR_WELL_KNOWN,
+                                ATTR_ASPATH, oasp->data, oasp->len)) == -1)
+                        return (-1);
+                aspath_put(oasp);
+                wlen += r; len -= r;
+                if ((r = attr_write(up_attr_buf + wlen, len, (ATTR_TRANSITIVE | ATTR_OPTIONAL),
+                                ATTR_NEW_ASPATH, path->data, path->len)) == -1)
+                        return (-1);
+         }
+         else if ((r = attr_write(up_attr_buf + wlen, len, ATTR_WELL_KNOWN,
 	    ATTR_ASPATH, path->data, path->len)) == -1)
 		return (-1);
 	aspath_put(path);
