--- ./bgpd/printconf.c.dist	Wed Jan 10 08:56:49 2007
+++ ./bgpd/printconf.c	Tue Jan  9 10:08:40 2007
@@ -176,7 +176,7 @@
 	struct in_addr		 ina;
 	struct listen_addr	*la;
 
-	printf("AS %u\n", conf->as);
+	printf("AS %u.%u\n", ((conf->as >> 16) & 65535), (conf->as & 65535));
 	ina.s_addr = conf->bgpid;
 	printf("router-id %s\n", inet_ntoa(ina));
 	if (conf->holdtime)
@@ -268,7 +268,8 @@
 	if (p->descr[0])
 		printf("%s\tdescr \"%s\"\n", c, p->descr);
 	if (p->remote_as)
-		printf("%s\tremote-as %u\n", c, p->remote_as);
+		printf("%s\tremote-as %u.%u\n", c, 
+		    ((p->remote_as >> 16) & 65535), (p->remote_as & 65535));
 	if (p->distance > 1)
 		printf("%s\tmultihop %u\n", c, p->distance);
 	if (p->passive)
@@ -457,13 +458,13 @@
 
 	if (r->match.as.type) {
 		if (r->match.as.type == AS_ALL)
-			printf("AS %u ", r->match.as.as);
+			printf("AS %u.%u ", ((r->match.as.as >> 16) & 65535), (r->match.as.as & 65535));
 		else if (r->match.as.type == AS_SOURCE)
-			printf("source-as %u ", r->match.as.as);
+			printf("source-as %u.%u ", ((r->match.as.as >> 16) & 65535), (r->match.as.as & 65535));
 		else if (r->match.as.type == AS_TRANSIT)
-			printf("transit-as %u ", r->match.as.as);
+			printf("transit-as %u.%u ", ((r->match.as.as >> 16) & 65535), (r->match.as.as & 65535));
 		else
-			printf("unfluffy-as %u ", r->match.as.as);
+			printf("unfluffy-as %u.%u ", ((r->match.as.as >> 16) & 65535), (r->match.as.as & 65535));
 	}
 
 	if (r->match.community.as != 0) {
