--- ./bgpd/parse.y.dist	Wed Jan 10 08:56:48 2007
+++ ./bgpd/parse.y	Tue Jan  9 10:04:12 2007
@@ -167,7 +167,8 @@
 %token	IPV4 IPV6
 %token	QUALIFY VIA
 %token	<v.string>		STRING
-%type	<v.number>		number asnumber optnumber yesno inout espah
+%type   <v.number>              dnumber asnumber
+%type	<v.number>		number optnumber yesno inout espah
 %type	<v.number>		family restart
 %type	<v.string>		string
 %type	<v.addr>		address
@@ -209,12 +210,45 @@
 		}
 		;
 
-asnumber	: number			{
-			if ($1 > USHRT_MAX) {
-				yyerror("AS too big: max %u", USHRT_MAX);
+dnumber         : STRING                        {
+                u_long       ulval, ulval2;
+                char *dot ;
+
+                if ((dot = strchr($1,'.')) != NULL) {
+                        *dot = '\0';
+                        ++dot ; 
+                        if (atoul(dot,&ulval2) == -1) {
+                                yyerror("\"%s\" is not a number", $1);
+                                free($1);
+                                YYERROR;
+                        }
+                        else if (atoul($1, &ulval) == -1) {
+                                yyerror("\"%s\" is not a number", $1);
+                                free($1);
 				YYERROR;
 			}
+                        else
+                                $$ = (ulval << 16) + ulval2 ;
 		}
+                else 
+                        if (atoul($1, &ulval) == -1) {
+                                yyerror("\"%s\" is not a number", $1);
+                                free($1);
+                                YYERROR;
+                       } 
+                       else
+                               $$ = ulval;
+                       free($1);
+                }
+                ;
+
+asnumber        : dnumber {
+                      if ($1 > ULONG_MAX) {
+                              yyerror("AS too big: max %u", ULONG_MAX);
+				YYERROR;
+       		      }
+ 		}
+                ;
 
 string		: string STRING				{
 			if (asprintf(&$$, "%s %s", $1, $2) == -1)
@@ -2172,6 +2206,7 @@
 	p->conf.capabilities.mp_v4 = SAFI_UNICAST;
 	p->conf.capabilities.mp_v6 = SAFI_NONE;
 	p->conf.capabilities.refresh = 1;
+        p->conf.capabilities.as_4bytes = 1;
 	p->conf.capabilities.restart = 0;
 	p->conf.softreconfig_in = 1;
 	p->conf.softreconfig_out = 1;
