--- ./bgpd/bgpd.h.dist	Wed Jan 10 08:56:48 2007
+++ ./bgpd/bgpd.h	Tue Jan  9 09:53:29 2007
@@ -155,7 +155,7 @@
 	int					 log;
 	u_int32_t				 bgpid;
 	u_int32_t				 clusterid;
-	u_int16_t				 as;
+	u_int32_t				 as;
 	u_int16_t				 holdtime;
 	u_int16_t				 min_holdtime;
 };
@@ -214,6 +214,7 @@
 	u_int8_t	mp_v6;
 	u_int8_t	refresh;	/* route refresh, RFC 2918 */
 	u_int8_t	restart;	/* draft-ietf-idr-restart */
+        u_int8_t        as_4bytes;      /* 4 byte AS capability */      
 };
 
 struct peer_config {
@@ -232,7 +233,7 @@
 	enum enforce_as		 enforce_as;
 	enum reconf_action	 reconf_action;
 	u_int16_t		 max_prefix_restart;
-	u_int16_t		 remote_as;
+	u_int32_t		 remote_as;
 	u_int16_t		 holdtime;
 	u_int16_t		 min_holdtime;
 	u_int8_t		 template;
@@ -246,8 +247,13 @@
 	u_int8_t		 reflector_client;
 	u_int8_t		 softreconfig_in;
 	u_int8_t		 softreconfig_out;
+        u_int8_t                 as_4bytes;
 };
 
+
+#define AS_TRANS                23456
+
+
 struct network_config {
 	struct bgpd_addr	prefix;
 	struct filter_set_head	attrset;
@@ -387,7 +393,8 @@
 	ERR_UPD_NEXTHOP,
 	ERR_UPD_OPTATTR,
 	ERR_UPD_NETWORK,
-	ERR_UPD_ASPATH
+	ERR_UPD_ASPATH,
+	ERR_UPD_NEWASPATH
 };
 
 enum suberr_cease {
@@ -517,7 +524,7 @@
 
 struct filter_as {
 	enum as_spec	type;
-	u_int16_t	as;
+	u_int32_t	as;
 };
 
 struct ctl_show_rib_request {
@@ -576,6 +583,29 @@
 #define	COMMUNITY_NO_EXPSUBCONFED	0xff03
 #define	COMMUNITY_NO_PEER		0xff04	/* rfc3765 */
 
+/* BGP Path Attributes */
+#define ATTRIBUTE_ORIGIN                            1
+#define ATTRIBUTE_AS_PATH                           2
+#define ATTRIBUTE_NEXT_HOP                          3
+#define ATTRIBUTE_MULTI_EXIT_DISC                   4
+#define ATTRIBUTE_LOCAL_PREF                        5
+#define ATTRIBUTE_ATOMIC_AGGREGATE                  6
+#define ATTRIBUTE_AGGREGATOR                        7
+#define ATTRIBUTE_COMMUNITY                         8
+#define ATTRIBUTE_ORIGINATOR_ID                     9
+#define ATTRIBUTE_CLUSTER_LIST                     10
+#define ATTRIBUTE_DPA                              11
+#define ATTRIBUTE_ADVERTISER                       12
+#define ATTRIBUTE_RCID_PATH_CLUSTER_ID             13
+#define ATTRIBUTE_MP_REACH_NLRI                    14
+#define ATTRIBUTE_MP_UNREACH_NLRI                  15
+#define ATTRIBUTE_EXTENDED_COMMUNITIES             16
+#define ATTRIBUTE_NEW_AS_PATH                      17
+#define ATTRIBUTE_NEW_AGGREGATOR                   18
+#define ATTRIBUTE_SSA                              19
+#define ATTRIBUTE_CONNECTOR                        20
+#define ATTRIBUTE_AS_PATHLIMIT                     21
+
 struct filter_prefix {
 	struct bgpd_addr	addr;
 	u_int8_t		len;
@@ -589,7 +619,7 @@
 };
 
 struct filter_community {
-	int			as;
+	u_int32_t      		as;
 	int			type;
 };
 
@@ -784,8 +814,8 @@
 const char	*log_addr(const struct bgpd_addr *);
 const char	*log_in6addr(const struct in6_addr *);
 const char *	 log_sockaddr(struct sockaddr *);
-int		 aspath_snprint(char *, size_t, void *, u_int16_t);
-int		 aspath_asprint(char **, void *, u_int16_t);
-size_t		 aspath_strlen(void *, u_int16_t);
+int		 aspath_snprint(char *, size_t, void *, u_int16_t, int);
+int		 aspath_asprint(char **, void *, u_int16_t, int);
+size_t		 aspath_strlen(void *, u_int16_t, int);
 
 #endif /* __BGPD_H__ */
