--- ./bgpctl/bgpctl.c.dist	Tue Jan  9 16:59:35 2007
+++ ./bgpctl/bgpctl.c	Tue Jan  9 05:19:34 2007
@@ -392,7 +392,7 @@
 void
 show_summary_head(void)
 {
-	printf("%-20s %-5s %-10s %-10s %-5s %-8s %s\n", "Neighbor", "AS",
+	printf("%-20s %-11s %-10s %-10s %-5s %-8s %s\n", "Neighbor", "AS",
 	    "MsgRcvd", "MsgSent", "OutQ", "Up/Down", "State/PrefixRcvd");
 }
 
@@ -401,6 +401,7 @@
 {
 	struct peer		*p;
 	char			*s;
+        char                     asstr[12];
 
 	switch (imsg->hdr.type) {
 	case IMSG_CTL_SHOW_NEIGHBOR:
@@ -409,8 +410,11 @@
 		    p->conf.remote_masklen, nodescr);
 		if (strlen(s) >= 20)
 			s[20] = 0;
-		printf("%-20s %5u %10llu %10llu %5u %-8s ",
-		    s, p->conf.remote_as,
+
+                /* +4-Byte AS:   display as numbers as x.y */
+                sprintf(asstr,"%5u.%5u",((p->conf.remote_as >> 16) & 65535),(p->conf.remote_as & 65535));
+		printf("%-20s %11s %10llu %10llu %5u %-8s ",
+		    s, asstr,
 		    p->stats.msg_rcvd_open + p->stats.msg_rcvd_notification +
 		    p->stats.msg_rcvd_update + p->stats.msg_rcvd_keepalive +
 		    p->stats.msg_rcvd_rrefresh,
@@ -448,7 +452,7 @@
 		p = imsg->data;
 		s = fmt_peer(p->conf.descr, &p->conf.remote_addr,
 		    p->conf.remote_masklen, nodescr);
-		printf("%s %u %s\n", s, p->conf.remote_as,
+		printf("%s %u.%u %s\n", s, ((p->conf.remote_as >> 16) & 65535),(p->conf.remote_as & 65535),
 		    statenames[p->state]);
 		free(s);
 		break;
@@ -489,7 +493,7 @@
 		if (p->conf.remote_as == 0 && p->conf.template)
 			printf("remote AS: accept any");
 		else
-			printf("remote AS %u", p->conf.remote_as);
+		  printf("remote AS %u.%u", ((p->conf.remote_as >> 16) & 65535),(p->conf.remote_as & 65535));
 		if (p->conf.template)
 			printf(", Template");
 		if (p->conf.cloned)
@@ -509,7 +513,7 @@
 		    fmt_timeframe(p->stats.last_read),
 		    p->holdtime, p->holdtime/3);
 		if (p->capa.peer.mp_v4 || p->capa.peer.mp_v6 ||
-		    p->capa.peer.refresh) {
+		    p->capa.peer.refresh || p->capa.peer.restart || p->capa.peer.as_4bytes) {
 			printf("  Neighbor capabilities:\n");
 			if (p->capa.peer.mp_v4) {
 				printf("    Multiprotocol extensions: IPv4");
@@ -523,6 +527,8 @@
 				printf("    Route Refresh\n");
 			if (p->capa.peer.restart)
 				printf("    Graceful Restart\n");
+			if (p->capa.peer.as_4bytes)
+				printf("    4-Byte ASNs\n");
 		}
 		printf("\n");
 		switch (nv) {
@@ -1047,7 +1053,7 @@
 
 		asdata = imsg->data;
 		asdata += sizeof(struct ctl_show_rib);
-		if (aspath_asprint(&aspath, asdata, rib.aspath_len) == -1)
+		if (aspath_asprint(&aspath, asdata, rib.aspath_len, 4) == -1)
 			err(1, NULL);
 		if (strlen(aspath) > 0)
 			printf("%s ", aspath);
@@ -1084,7 +1090,7 @@
 
 		data = imsg->data;
 		data += sizeof(struct ctl_show_rib);
-		if (aspath_asprint(&aspath, data, rib.aspath_len) == -1)
+		if (aspath_asprint(&aspath, data, rib.aspath_len, 4) == -1)
 			err(1, NULL);
 		if (strlen(aspath) > 0)
 			printf("    %s\n", aspath);
