--- ./bgpd/session.c.dist	Wed Jan 10 09:22:24 2007
+++ ./bgpd/session.c	Wed Jan 10 09:19:08 2007
@@ -16,6 +16,9 @@
  * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  */
 
+/* +4-Byte AS:   modifications for 4 Byte AS Number Support - 
+                 Geoff Huston, January 2007 */
+
 #include <sys/param.h>
 #include <sys/types.h>
 
@@ -64,6 +67,8 @@
 void	session_tcp_established(struct peer *);
 void	session_capa_ann_none(struct peer *);
 int	session_capa_mp_add(struct buf *, u_int16_t, u_int8_t);
+/* +4-Byte AS: add the 4byte AS capability to the Open message block */
+int     session_capa_as_4bytes_add(struct buf *, u_int32_t) ;         
 void	session_open(struct peer *);
 void	session_keepalive(struct peer *);
 void	session_update(u_int32_t, void *, size_t);
@@ -1153,12 +1158,15 @@
 		log_warn("getpeername");
 }
 
+
 void
 session_capa_ann_none(struct peer *peer)
 {
 	peer->capa.ann.mp_v4 = SAFI_NONE;
 	peer->capa.ann.mp_v4 = SAFI_NONE;
 	peer->capa.ann.refresh = 0;
+        /* +4-Byte AS:   reset the 4 byte capability announce */
+        peer->capa.ann.as_4bytes = 0 ;
 }
 
 int
@@ -1179,6 +1187,23 @@
 	return (errs);
 }
 
+/* +4-Byte AS:   add the 4byte AS capability to the Open message block */
+
+int
+session_capa_as_4bytes_add(struct buf *buf, u_int32_t myas)
+{
+        u_int8_t                 capa_code, capa_len;
+        int                      errs = 0;
+ 
+        myas = htonl(myas) ;
+        capa_code = CAPA_4AS;
+        capa_len = 4;
+        errs += buf_add(buf, &capa_code, sizeof(capa_code));
+        errs += buf_add(buf, &capa_len, sizeof(capa_len));
+        errs += buf_add(buf, &myas, sizeof(myas));
+        return (errs);
+}
+
 void
 session_open(struct peer *p)
 {
@@ -1186,6 +1211,8 @@
 	struct buf		*buf;
 	struct mrt		*mrt;
 	u_int16_t		 len;
+        /* +4-Byte AS:   add short_as var */
+        u_int16_t                short_as;
 	int			 errs = 0;
 	u_int8_t		 op_type, op_len = 0, optparamlen = 0;
 	u_int8_t		 capa_code, capa_len;
@@ -1200,6 +1227,10 @@
 	if (p->capa.ann.refresh)
 		op_len += 2 + 0;	/* 1 code + 1 len, no data */
 
+        /* +4-Byte AS:   capability advertisement (65,4, ASvalue */
+        if (p->capa.ann.as_4bytes)
+                op_len += 2 + 4 ;      /* 1 code + 1 len + 4 data */ 
+
 	if (op_len > 0)
 		optparamlen = sizeof(op_type) + sizeof(op_len) + op_len;
 	len = MSGSIZE_OPEN_MIN + optparamlen;
@@ -1208,7 +1239,11 @@
 	msg.header.len = htons(len);
 	msg.header.type = OPEN;
 	msg.version = 4;
-	msg.myas = htons(conf->as);
+        /* +4-Byte AS:   myas is the low 16 bits if the upper 16 bits of the AS are zero - AS_TRANS otherwise */
+        if (!((conf->as >> 16) & 65535)) 
+                short_as = (u_int16_t) conf->as;
+        else short_as = AS_TRANS ;
+        msg.myas = htons(short_as) ;
 	if (p->conf.holdtime)
 		msg.holdtime = htons(p->conf.holdtime);
 	else
@@ -1234,6 +1269,10 @@
 		errs += buf_add(buf, &op_type, sizeof(op_type));
 		errs += buf_add(buf, &op_len, sizeof(op_len));
 
+                /* +4-Byte AS: 4 Byte as capability */
+                if (p->capa.ann.as_4bytes) {
+                        errs += session_capa_as_4bytes_add(buf, conf->as);
+
 		/* multiprotocol extensions, RFC 2858 */
 		if (p->capa.ann.mp_v4)
 			errs += session_capa_mp_add(buf, AFI_IPv4,
@@ -1708,7 +1747,10 @@
 	u_int32_t	 bgpid;
 	u_int8_t	 optparamlen, plen;
 	u_int8_t	 op_type, op_len;
+        int              error_code;
 
+        /* +4-Byte AS:   reset peers' 4byte capability */
+        peer->capa.peer.as_4bytes = 0;
 	p = peer->rbuf->rptr;
 	p += MSGSIZE_HEADER_MARKER;
 	memcpy(&msglen, p, sizeof(msglen));
@@ -1742,12 +1784,7 @@
 		peer->conf.ebgp = (peer->conf.remote_as != conf->as);
 	}
 
-	if (peer->conf.remote_as != ntohs(as)) {
-		log_peer_warnx(&peer->conf, "peer sent wrong AS %u", ntohs(as));
-		session_notification(peer, ERR_OPEN, ERR_OPEN_AS, NULL, 0);
-		change_state(peer, STATE_IDLE, EVNT_RCVD_OPEN);
-		return (-1);
-	}
+        /* +4-Byte AS:   delay check of received vs configured AS */
 
 	memcpy(&oholdtime, p, sizeof(oholdtime));
 	p += sizeof(oholdtime);
@@ -1827,8 +1864,10 @@
 
 		switch (op_type) {
 		case OPT_PARAM_CAPABILITIES:		/* RFC 3392 */
-			if (parse_capabilities(peer, op_val, op_len) == -1) {
-				session_notification(peer, ERR_OPEN, 0,
+                         /* +4-Byte AS:   parse_capabilities returns the negative of the error code */
+			if (error_code = parse_capabilities(peer, op_val, op_len) < 0) {
+  			        error_code = -1 - error_code ;
+				session_notification(peer, ERR_OPEN, error_code,
 				    NULL, 0);
 				change_state(peer, STATE_IDLE, EVNT_RCVD_OPEN);
 				return (-1);
@@ -1855,6 +1894,14 @@
 		}
 	}
 
+        /* +4-Byte AS:   delayed check of received AS vs configured peer AS */
+        if ((peer->conf.remote_as != ntohs(as)) && (!peer->capa.peer.as_4bytes)) {
+                log_peer_warnx(&peer->conf, "peer sent wrong AS %u", ntohs(as));
+                session_notification(peer, ERR_OPEN, ERR_OPEN_AS, NULL, 0);
+                change_state(peer, STATE_IDLE, EVNT_RCVD_OPEN);
+                return (-1);
+        }
+
 	return (0);
 }
 
@@ -1904,7 +1951,6 @@
 	memcpy(&r.safi, p, sizeof(r.safi));
 
 	/* afi/safi unchecked -	unrecognized values will be ignored anyway */
-
 	if (imsg_compose(ibuf_rde, IMSG_REFRESH, peer->conf.id, 0, -1, &r,
 	    sizeof(r)) == -1)
 		return (-1);
@@ -2016,6 +2062,8 @@
 	u_char		*capa_val;
 	u_int16_t	 mp_afi;
 	u_int8_t	 mp_safi;
+        /* +4-Byte AS:   add remote as from 4 byte capability announce */
+        u_int32_t        remote_as;
 
 	len = dlen;
 	while (len > 0) {
@@ -2045,6 +2093,23 @@
 			capa_val = NULL;
 
 		switch (capa_code) {
+                /* +4-Byte AS:   4 byte AS capability advertisement */
+                case CAPA_4AS:
+                        if (capa_len != 4) {
+                                log_peer_warnx(&peer->conf,
+                                    "parse_capabilities: "
+                                    "expect len 4, len is %u", capa_len);
+                                return (-1);
+                        }
+                        memcpy(&remote_as, capa_val, sizeof(remote_as));
+                        remote_as = ntohl(remote_as);
+                        peer->capa.peer.as_4bytes = 1 ;
+                        if (peer->conf.remote_as != remote_as) {
+                                log_peer_warnx(&peer->conf, "peer sent wrong AS %u.%u", 
+					       ((remote_as >> 16) & 65535),(remote_as & 65535));
+                                return (0 - (ERR_OPEN_AS + 1));
+                        }
+                        break ;
 		case CAPA_MP:			/* RFC 2858 */
 			if (capa_len != 4) {
 				log_peer_warnx(&peer->conf,
