--- ./bgpctl/bgpctl.c.dist	Wed Jan 10 09:22:25 2007
+++ ./bgpctl/bgpctl.c	Wed Jan 10 09:19:50 2007
@@ -16,6 +16,9 @@
  * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  */
 
+/* +4-Byte AS:   modifications for 4 Byte AS Number Support - 
+                 Geoff Huston, January 2007 */
+
 #include <sys/types.h>
 #include <sys/socket.h>
 #include <sys/un.h>
@@ -379,7 +382,9 @@
 void
 show_summary_head(void)
 {
-	printf("%-20s %-5s %-10s %-10s %-5s %-8s %s\n", "Neighbor", "AS",
+
+/* +4-Byte AS:   wider field for displayed AS Numbers (5 to 11 cols) */
+	printf("%-20s %-11s %-10s %-10s %-5s %-8s %s\n", "Neighbor", "AS",
 	    "MsgRcvd", "MsgSent", "OutQ", "Up/Down", "State/PrefixRcvd");
 }
 
@@ -388,6 +393,7 @@
 {
 	struct peer		*p;
 	char			*s;
+        char                     asstr[12];
 
 	switch (imsg->hdr.type) {
 	case IMSG_CTL_SHOW_NEIGHBOR:
@@ -395,8 +401,12 @@
 		s = fmt_peer(&p->conf, nodescr);
 		if (strlen(s) >= 20)
 			s[20] = 0;
-		printf("%-20s %5u %10llu %10llu %5u %-8s ",
-		    s, p->conf.remote_as,
+
+                /* +4-Byte AS:   display as numbers as x.y */
+                sprintf(asstr,"%5u.%5u",((p->conf.remote_as >> 16) & 65535),(p->conf.remote_as & 65535));
+		printf("%-20s %11s %10llu %10llu %5u %-8s ",
+		    s, asstr,
+		    (p->conf.remote_as & 65535),
 		    p->stats.msg_rcvd_open + p->stats.msg_rcvd_notification +
 		    p->stats.msg_rcvd_update + p->stats.msg_rcvd_keepalive +
 		    p->stats.msg_rcvd_rrefresh,
@@ -433,7 +443,11 @@
 	case IMSG_CTL_SHOW_NEIGHBOR:
 		p = imsg->data;
 		s = fmt_peer(&p->conf, nodescr);
-		printf("%s %u %s\n", s, p->conf.remote_as,
+
+/* +4-Byte AS:   display as numbers as x.y */
+		printf("%s %u.%u %s\n", s, 
+                    ((p->conf.remote_as >> 16) & 65535), 
+		    (p->conf.remote_as & 65535),
 		    statenames[p->state]);
 		free(s);
 		break;
@@ -474,7 +488,11 @@
 		if (p->conf.remote_as == 0 && p->conf.template)
 			printf("remote AS: accept any");
 		else
-			printf("remote AS %u", p->conf.remote_as);
+
+/* +4-Byte AS:   display as numbers as x.y */
+			printf("remote AS %u.%u", 
+			       ((p->conf.remote_as >> 16) & 65535),
+                               (p->conf.remote_as & 65535));
 		if (p->conf.template)
 			printf(", Template");
 		if (p->conf.cloned)
@@ -1010,7 +1028,9 @@
 
 		asdata = imsg->data;
 		asdata += sizeof(struct ctl_show_rib);
-		if (aspath_asprint(&aspath, asdata, rib.aspath_len) == -1)
+
+/* +4-Byte AS:   this is printing out a 4byte AS path data structure*/
+		if (aspath_asprint(&aspath, asdata, rib.aspath_len,4) == -1)
 			err(1, NULL);
 		if (strlen(aspath) > 0)
 			printf("%s ", aspath);
