#include <stdlib.h>
#ifndef lint
#ifdef __unused
__unused
#endif
static char const 
yyrcsid[] = "$FreeBSD: src/usr.bin/yacc/skeleton.c,v 1.37 2003/02/12 18:03:55 davidc Exp $";
#endif
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#if defined(__cplusplus) || __STDC__
static int yygrowstack(void);
#else
static int yygrowstack();
#endif
#define YYPREFIX "yy"
#line 23 "parse.y"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <err.h>
#include <errno.h>
#include <limits.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>

#include "bgpd.h"
#include "mrt.h"
#include "session.h"

static struct bgpd_config	*conf;
static struct mrt_head		*mrtconf;
static struct network_head	*netconf;
static struct peer		*peer_l, *peer_l_old;
static struct peer		*curpeer;
static struct peer		*curgroup;
static struct filter_head	*filter_l;
static struct filter_head	*peerfilter_l;
static struct filter_head	*groupfilter_l;
static struct filter_rule	*curpeer_filter[2];
static struct filter_rule	*curgroup_filter[2];
static struct listen_addrs	*listen_addrs;
static FILE			*fin = NULL;
static int			 lineno = 1;
static int			 errors = 0;
static int			 pdebug = 1;
static u_int32_t		 id;
char				*infile;

int	 yyerror(const char *, ...);
int	 yyparse(void);
int	 kw_cmp(const void *, const void *);
int	 lookup(char *);
int	 lgetc(FILE *);
int	 lungetc(int);
int	 findeol(void);
int	 yylex(void);

struct filter_peers_l {
	struct filter_peers_l	*next;
	struct filter_peers	 p;
};

struct filter_prefix_l {
	struct filter_prefix_l	*next;
	struct filter_prefix	 p;
};

struct filter_as_l {
	struct filter_as_l	*next;
	struct filter_as	 a;
};

struct filter_match_l {
	struct filter_match	 m;
	struct filter_prefix_l	*prefix_l;
	struct filter_as_l	*as_l;
} fmopts;

struct peer	*alloc_peer(void);
struct peer	*new_peer(void);
struct peer	*new_group(void);
int		 add_mrtconfig(enum mrt_type, char *, time_t, struct peer *);
int		 get_id(struct peer *);
int		 expand_rule(struct filter_rule *, struct filter_peers_l *,
		    struct filter_match_l *, struct filter_set_head *);
int		 str2key(char *, char *, size_t);
int		 neighbor_consistent(struct peer *);
int		 merge_filterset(struct filter_set_head *, struct filter_set *);
void		 copy_filterset(struct filter_set_head *,
		    struct filter_set_head *);
void		 move_filterset(struct filter_set_head *,
		    struct filter_set_head *);
struct filter_rule	*get_rule(enum action_types);

TAILQ_HEAD(symhead, sym)	 symhead = TAILQ_HEAD_INITIALIZER(symhead);
struct sym {
	TAILQ_ENTRY(sym)	 entry;
	int			 used;
	int			 persist;
	char			*nam;
	char			*val;
};

int	 symset(const char *, const char *, int);
char	*symget(const char *);
int	 atoul(char *, u_long *);
int	 getcommunity(char *);
int	 parsecommunity(char *, int *, int *);

typedef struct {
	union {
		u_int32_t		 number;
		char			*string;
		struct bgpd_addr	 addr;
		u_int8_t		 u8;
		struct filter_peers_l	*filter_peers;
		struct filter_match_l	 filter_match;
		struct filter_prefix_l	*filter_prefix;
		struct filter_as_l	*filter_as;
		struct filter_prefixlen	 prefixlen;
		struct filter_set	*filter_set;
		struct filter_set_head	*filter_set_head;
		struct {
			struct bgpd_addr	prefix;
			u_int8_t		len;
		}			prefix;
		struct {
			u_int8_t		enc_alg;
			char			enc_key[IPSEC_ENC_KEY_LEN];
			u_int8_t		enc_key_len;
		}			encspec;
	} v;
	int lineno;
} YYSTYPE;

#line 149 "parse.c"
#define YYERRCODE 256
#define AS 257
#define ROUTERID 258
#define HOLDTIME 259
#define YMIN 260
#define LISTEN 261
#define ON 262
#define FIBUPDATE 263
#define RDE 264
#define EVALUATE 265
#define IGNORE 266
#define COMPARE 267
#define GROUP 268
#define NEIGHBOR 269
#define NETWORK 270
#define REMOTEAS 271
#define DESCR 272
#define LOCALADDR 273
#define MULTIHOP 274
#define PASSIVE 275
#define MAXPREFIX 276
#define ANNOUNCE 277
#define ENFORCE 278
#define NEIGHBORAS 279
#define CAPABILITIES 280
#define REFLECTOR 281
#define DEPEND 282
#define DOWN 283
#define SOFTRECONFIG 284
#define DUMP 285
#define IN 286
#define OUT 287
#define LOG 288
#define ROUTECOLL 289
#define TRANSPARENT 290
#define TCP 291
#define MD5SIG 292
#define PASSWORD 293
#define KEY 294
#define ALLOW 295
#define DENY 296
#define MATCH 297
#define QUICK 298
#define FROM 299
#define TO 300
#define ANY 301
#define CONNECTED 302
#define STATIC 303
#define PREFIX 304
#define PREFIXLEN 305
#define SOURCEAS 306
#define TRANSITAS 307
#define COMMUNITY 308
#define DELETE 309
#define SET 310
#define LOCALPREF 311
#define MED 312
#define METRIC 313
#define NEXTHOP 314
#define REJECT 315
#define BLACKHOLE 316
#define NOMODIFY 317
#define PREPEND_SELF 318
#define PREPEND_PEER 319
#define PFTABLE 320
#define WEIGHT 321
#define RTLABEL 322
#define ERROR 323
#define IPSEC 324
#define ESP 325
#define AH 326
#define SPI 327
#define IKE 328
#define IPV4 329
#define IPV6 330
#define STRING 331
const short yylhs[] = {                                        -1,
    0,    0,    0,    0,    0,    0,    0,    0,    3,    1,
    2,    9,    9,    5,   42,   41,   41,   41,   41,   41,
   41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
   41,   41,   41,   41,   46,    6,    6,   10,   11,   12,
   12,   47,   47,   48,    4,    4,   49,   51,   43,   53,
   44,   52,   52,   54,   54,   54,   50,   50,   56,   56,
   57,   57,   55,   55,   55,   55,   55,   55,   55,   55,
   55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
   55,   55,   55,   55,   55,   55,    8,    8,    7,    7,
   40,   40,   45,   13,   13,   13,   14,   14,   15,   15,
   19,   19,   18,   18,   17,   17,   17,   35,   35,   36,
   36,   36,   34,   34,   33,   25,   25,   27,   27,   26,
   26,   28,   28,   28,   24,   24,   23,   22,   59,   22,
   20,   20,   21,   21,   21,   21,   29,   29,   39,   39,
   39,   31,   31,   31,   32,   32,   16,   16,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   58,
   58,   37,   37,   37,   37,   37,   37,   38,   38,
};
const short yylen[] = {                                         2,
    0,    2,    3,    3,    3,    3,    3,    3,    1,    1,
    1,    2,    1,    1,    3,    2,    2,    2,    3,    3,
    2,    2,    2,    2,    3,    4,    4,    3,    3,    4,
    1,    3,    3,    4,    5,    1,    1,    1,    3,    1,
    1,    2,    0,    2,    0,    1,    0,    0,    5,    0,
    8,    2,    1,    2,    2,    2,    4,    0,    2,    1,
    2,    2,    2,    2,    2,    2,    1,    1,    2,    3,
    3,    2,    3,    2,    4,    4,    3,    8,    3,    2,
    7,    1,    1,    2,    3,    3,    1,    1,    1,    1,
    0,    2,    6,    1,    1,    1,    0,    1,    1,    1,
    1,    3,    1,    3,    1,    1,    2,    2,    4,    1,
    3,    4,    1,    3,    1,    1,    3,    1,    3,    2,
    4,    1,    3,    4,    1,    3,    1,    0,    0,    2,
    1,    2,    1,    2,    1,    2,    2,    3,    1,    1,
    1,    0,    2,    7,    3,    1,    0,    1,    2,    3,
    3,    2,    3,    3,    2,    3,    3,    2,    3,    3,
    2,    2,    2,    2,    2,    2,    2,    2,    3,    1,
    0,    1,    2,    2,    1,    2,    1,    1,    2,
};
const short yydefred[] = {                                      1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   94,   95,   96,    0,    2,    0,
    0,    0,    0,    0,    0,   31,    0,    8,   10,   11,
   16,   38,   17,    0,    9,   18,    0,   14,   21,    0,
    0,   13,    0,    0,    0,    0,    0,    0,   24,   22,
   23,    0,   98,    0,    3,    4,    5,    6,    7,    0,
   19,   20,    0,   32,   33,   12,    0,    0,    0,   29,
   28,    0,    0,    0,   25,   36,   37,    0,    0,    0,
   99,  100,    0,    0,   40,   41,   48,   34,   42,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  143,    0,   27,   26,   39,   46,   30,    0,    0,  105,
    0,  106,  101,    0,    0,   50,  148,    0,    0,    0,
  149,    0,    0,  152,    0,    0,  155,  163,  162,  164,
  161,  165,  166,  167,    0,    0,  158,  168,    0,   35,
  107,  103,    0,    0,    0,    0,   49,    0,  169,  150,
  151,  153,  154,  156,  157,  159,  160,    0,  102,  170,
    0,   93,  139,    0,    0,  140,  141,    0,    0,    0,
  131,  135,  116,  133,    0,    0,    0,    0,    0,    0,
    0,    0,   67,    0,    0,    0,    0,    0,   68,    0,
    0,    0,    0,    0,    0,   82,    0,   53,    0,  146,
    0,  104,    0,    0,  115,  108,  172,    0,    0,    0,
    0,  134,    0,  136,  118,    0,  132,    0,  127,  120,
    0,    0,    0,   60,    0,   56,    0,   69,   63,    0,
   65,   66,   74,    0,   87,   88,   72,    0,    0,   84,
    0,    0,    0,    0,   80,    0,   89,   90,    0,   55,
   51,   52,   54,    0,    0,    0,  113,    0,    0,  173,
  174,  176,  178,    0,    0,  137,  117,    0,    0,  125,
    0,    0,   62,   61,   57,   59,   44,   70,   79,   71,
   73,   85,   86,    0,    0,    0,   77,    0,  144,  145,
    0,    0,  109,  179,  138,  119,    0,    0,  121,    0,
    0,    0,    0,    0,  114,    0,  126,    0,    0,  112,
  124,    0,    0,   81,    0,    0,   78,   92,
};
const short yydgoto[] = {                                       1,
   30,  219,  106,  107,   39,   79,  249,  238,   43,  112,
  205,   87,   20,   54,   83,  118,  113,  143,  114,  170,
  171,  144,  270,  271,  172,  173,  216,  272,  212,  200,
   70,  201,  257,  258,  174,  259,  213,  265,  175,  317,
   21,   22,  195,   24,   25,  196,   68,  226,   27,  147,
  115,  197,  148,  198,  199,  223,  224,  255,  145,
};
const short yysindex[] = {                                      0,
  -10,   57, -270, -254, -230, -183, -248, -249, -246, -245,
 -242, -233, -248, -248,    0,    0,    0,   58,    0, -166,
  125,  131,  133,  137,  139,    0, -107,    0,    0,    0,
    0,    0,    0, -170,    0,    0, -254,    0,    0,  -98,
 -201,    0,   -9, -146, -146,  -35, -146, -227,    0,    0,
    0, -246,    0, -229,    0,    0,    0,    0,    0, -165,
    0,    0, -161,    0,    0,    0,  161,   49,   -8,    0,
    0, -146, -146, -170,    0,    0,    0, -170, -158, -154,
    0,    0, -118,  132,    0,    0,    0,    0,    0,  161,
 -128,  -39,  -34,  -29, -157, -170, -170, -144,  -22, -133,
    0,   62,    0,    0,    0,    0,    0, -170, -132,    0,
 -223,    0,    0,    0,   82,    0,    0, -124, -170, -170,
    0, -170, -170,    0, -170, -170,    0,    0,    0,    0,
    0,    0,    0,    0, -170, -170,    0,    0,  161,    0,
    0,    0,  -16, -146,  -89,  161,    0,  234,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  278,    0,    0,
 -223,    0,    0, -110,  -23,    0,    0, -123, -207,  -89,
    0,    0,    0,    0, -108,  264,  199, -218, -270, -246,
 -254, -170,    0, -170, -224,  -67, -254,  -48,    0, -213,
 -111,  -61,   -8, -188,  199,    0,  130,    0,  199,    0,
   52,    0,  132, -105,    0,    0,    0,  163,  172,  173,
   31,    0, -170,    0,    0,    3,    0, -104,    0,    0,
  199,  199,  174,    0,  161,    0, -170,    0,    0, -154,
    0,    0,    0, -248,    0,    0,    0,  -96, -248,    0,
  -95, -248, -213, -138,    0,  114,    0,    0, -206,    0,
    0,    0,    0,  119,  278,  -92,    0,  201,  127,    0,
    0,    0,    0,  197, -170,    0,    0, -207, -270,    0,
  201,  134,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -246, -246,  161,    0,  -65,    0,    0,
    4,  -92,    0,    0,    0,    0,    5, -270,    0, -154,
 -154,  278, -170, -105,    0, -104,    0,   52,  -66,    0,
    0,  141,  -62,    0,  -60,  -58,    0,    0,
};
const short yyrindex[] = {                                      0,
    1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -148,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  151,  267,  267,    0,  267,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   61,    0,  151,    0,
    0,  267,  267,    0,    0,    0,    0,  271,    0,  272,
    0,    0,    0,   16,    0,    0,    0,    0,    0,  204,
  -47,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  271,    0,    0,
    0,    0,    0,   19,  137,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  295,    0,
    0,    0, -217,  267,    0,  294,    0,    1,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   -3,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  273,    0,    0,    0,
    0,    0,  151,    0,    0,    0,    1,    0,    0,    0,
   42,    0,    0,    0,    0,    0,    0,    0,  -43,  -42,
    0,    0,    0,    0,    0, -191,    0,    0,    0,    0,
    0,    0,    0,    0,  -81,    0,    0,    0,    0,  280,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -103,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -101,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  295,    0,    0,    0,    0,
  -40,    0,    0,    0,    0,    0,  -40,    0,    0,  283,
  284,    0,    0,  170,    0,  171,    0,   42,    0,    0,
    0,    0,    0,    0,  288,    0,    0,    0,
};
const short yygindex[] = {                                      0,
    0,   43,   -2,  208,   22, -137,    0,    0,  -44,   51,
   65,    0,    0,    0,    0,    0,  -59,    0,    0,    0,
  148,    0, -150,   50,    0, -142,    0,   25,    0,  -49,
   -4,   26, -147,   84,    0,   37,    0,    0,    0,    0,
    0,    0,  346,    0,    0,  347,  -36,  -68,    0,    0,
    0,    0,    0,  152, -136,    0,  128,   99,    0,
};
#define YYTABLESIZE 618
const short yytable[] = {                                      19,
   67,   67,   36,  119,  111,  120,  130,   80,  122,  208,
  123,   74,  204,  125,  218,  126,  206,  256,  269,  101,
  135,  110,  136,  122,  220,   38,  215,  160,  128,   34,
   89,   61,  102,  169,   50,   51,  209,  207,  210,  222,
   71,  227,   75,   43,  109,   31,  160,  160,  160,  163,
  171,  142,  242,  116,   33,  234,   44,   45,   76,   77,
   29,   67,   40,   64,   65,  171,   28,  103,  104,   81,
   82,  105,   76,   77,   47,  263,   32,  110,   37,   76,
   77,   41,   38,  171,   42,   46,  222,   62,   48,  121,
  124,  127,  264,  132,  133,  160,  137,   49,  166,  167,
   35,  202,  158,   78,  235,  236,  237,   32,  159,  176,
   85,  288,   35,  171,  171,  171,  150,  151,   52,  152,
  153,  287,  154,  155,   86,  296,  250,  267,  304,  306,
  253,   53,  156,  157,   55,  230,  247,  248,   38,  162,
   56,  129,   57,  245,  305,  131,   58,  307,   59,  109,
   97,   97,  273,  274,  284,  285,  246,  128,  129,  130,
   35,   60,  211,   69,  254,   84,   43,  163,   63,   88,
   67,   90,  108,   32,   43,  228,   66,   43,   74,  232,
  117,  233,  110,   43,  139,   43,  134,   43,  277,   43,
   43,   43,   43,   43,   43,   43,   43,  138,  141,   43,
   43,   43,   43,   43,  146,  290,  149,  214,  225,   43,
  266,  239,   32,  241,  164,  165,  166,  167,  168,  243,
  203,  229,   29,  260,  278,  203,   29,  171,   43,  171,
  244,  231,  261,  262,  280,  282,  286,  240,  203,  300,
  301,  161,   43,  289,  160,    2,    3,    4,    5,  302,
    6,  293,    7,    8,  251,  279,  294,    9,  299,   10,
  281,  303,  295,  283,  313,  314,   72,   73,  315,   47,
  316,  312,  318,   43,   11,  129,  142,   12,   13,   14,
   45,   15,   83,  147,   15,   16,   17,  175,  177,   64,
  171,   35,   75,   76,  111,  123,   35,   91,  275,   91,
  309,   35,   92,   93,   94,   95,  130,   35,   35,   96,
   97,   98,   99,  100,  268,  140,   43,  217,  297,   43,
   18,   66,  129,  129,  129,  129,  129,  308,  128,   43,
  311,   43,   43,   43,   43,   43,   43,   43,   43,  291,
  310,   43,   43,   43,   43,   43,   23,   26,  252,  171,
  276,   43,  171,  171,  171,  171,  292,    0,    0,  171,
  171,  171,  171,  171,    0,    0,    0,    0,   43,  298,
   43,   43,   43,   43,   43,    0,    0,    0,   43,   43,
   43,   43,   43,    0,   43,  177,    0,    0,  178,  292,
    0,    0,    0,    0,    0,  298,    0,    0,    0,    0,
  179,  180,  181,  182,  183,  184,  185,  186,    0,    0,
  187,  188,  189,  190,  191,    0,    0,    0,    0,    0,
  192,    0,    0,    0,    0,    0,    0,    0,    0,  221,
    0,    0,  178,    0,    0,    0,    0,    0,    0,  193,
    0,    0,    0,    0,  179,  180,  181,  182,  183,  184,
  185,  186,    0,  194,  187,  188,  189,  190,  191,   43,
    0,    0,   43,    0,  192,    0,    0,    0,    0,    0,
    0,    0,   43,    0,   43,   43,   43,   43,   43,   43,
   43,   43,    0,  193,   43,   43,   43,   43,   43,  177,
    0,    0,  178,    0,   43,    0,    0,  194,    0,    0,
    0,    0,    0,    0,  179,  180,  181,  182,  183,  184,
  185,  186,    0,   43,  187,  188,  189,  190,  191,  221,
    0,    0,  178,    0,  192,    0,    0,   43,    0,    0,
    0,    0,    0,    0,  179,  180,  181,  182,  183,  184,
  185,  186,    0,  193,  187,  188,  189,  190,  191,   43,
    0,    0,   43,    0,  192,    0,    0,  194,    0,    0,
    0,    0,    0,    0,   43,   43,   43,   43,   43,   43,
   43,   43,    0,  193,   43,   43,   43,   43,   43,    0,
    0,    0,    0,    0,   43,   91,    0,  194,   92,   93,
   94,   95,    0,    0,    0,   96,   97,   98,   99,  100,
    0,    0,   43,   43,    0,   43,   43,   43,   43,    0,
    0,    0,   43,   43,   43,   43,   43,   43,
};
const short yycheck[] = {                                      10,
   10,   10,    5,   43,  123,   45,   10,   52,   43,   33,
   45,   47,  123,   43,  123,   45,  164,  123,  123,   69,
   43,  125,   45,  125,  175,   10,  169,   44,   10,  260,
   67,   34,   69,  123,   13,   14,   60,   61,   62,  176,
   45,  260,   47,  125,  268,    3,   44,   44,   44,  257,
  268,  111,  190,   90,    4,  280,  302,  303,  286,  287,
  331,   10,  312,  265,  266,  257,   10,   72,   73,  299,
  300,   74,  286,  287,   10,   45,  331,  301,  262,  286,
  287,  331,  331,  301,  331,  331,  223,   37,  331,   92,
   93,   94,   62,   96,   97,   44,   99,  331,  306,  307,
  331,  161,  139,  331,  329,  330,  331,  331,  125,  146,
   60,  249,  331,  331,  306,  307,  119,  120,   61,  122,
  123,  328,  125,  126,   60,  268,  195,  125,  125,  125,
  199,  298,  135,  136,   10,  180,  325,  326,  123,  144,
   10,  123,   10,  193,  292,   95,   10,  298,   10,  268,
  299,  300,  221,  222,  293,  294,  193,  315,  316,  317,
  331,  269,  165,  310,  201,  331,  125,  257,  267,  331,
   10,  123,  331,  331,  256,  178,  331,  259,   47,  182,
  309,  184,  301,  123,  123,  125,  331,  269,  225,  271,
  272,  273,  274,  275,  276,  277,  278,  331,  331,  281,
  282,  283,  284,  285,  123,  255,  331,  331,   10,  291,
  213,  279,  331,  262,  304,  305,  306,  307,  308,  331,
  331,  179,  331,   61,  227,  331,  331,  331,  310,  331,
  292,  181,   61,   61,  331,  331,  123,  187,  331,  284,
  285,  143,  324,  125,   44,  256,  257,  258,  259,  286,
  261,  125,  263,  264,  125,  234,   60,  268,  125,  270,
  239,  327,  265,  242,  331,  125,  302,  303,  331,  269,
  331,  308,  331,  123,  285,  257,   10,  288,  289,  290,
   10,   10,   10,  331,  295,  296,  297,  331,  331,   10,
  331,  331,   10,   10,  125,  125,  331,   10,  125,  308,
  303,  331,  311,  312,  313,  314,  310,  331,  331,  318,
  319,  320,  321,  322,  216,  108,  256,  170,  269,  259,
  331,  331,  304,  305,  306,  307,  308,  302,  310,  269,
  306,  271,  272,  273,  274,  275,  276,  277,  278,  256,
  304,  281,  282,  283,  284,  285,    1,    1,  197,  308,
  223,  291,  311,  312,  313,  314,  258,   -1,   -1,  318,
  319,  320,  321,  322,   -1,   -1,   -1,   -1,  308,  271,
  310,  311,  312,  313,  314,   -1,   -1,   -1,  318,  319,
  320,  321,  322,   -1,  324,  256,   -1,   -1,  259,  291,
   -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,   -1,   -1,
  271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1,
  281,  282,  283,  284,  285,   -1,   -1,   -1,   -1,   -1,
  291,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,  259,   -1,   -1,   -1,   -1,   -1,   -1,  310,
   -1,   -1,   -1,   -1,  271,  272,  273,  274,  275,  276,
  277,  278,   -1,  324,  281,  282,  283,  284,  285,  256,
   -1,   -1,  259,   -1,  291,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  269,   -1,  271,  272,  273,  274,  275,  276,
  277,  278,   -1,  310,  281,  282,  283,  284,  285,  256,
   -1,   -1,  259,   -1,  291,   -1,   -1,  324,   -1,   -1,
   -1,   -1,   -1,   -1,  271,  272,  273,  274,  275,  276,
  277,  278,   -1,  310,  281,  282,  283,  284,  285,  256,
   -1,   -1,  259,   -1,  291,   -1,   -1,  324,   -1,   -1,
   -1,   -1,   -1,   -1,  271,  272,  273,  274,  275,  276,
  277,  278,   -1,  310,  281,  282,  283,  284,  285,  256,
   -1,   -1,  259,   -1,  291,   -1,   -1,  324,   -1,   -1,
   -1,   -1,   -1,   -1,  271,  272,  273,  274,  275,  276,
  277,  278,   -1,  310,  281,  282,  283,  284,  285,   -1,
   -1,   -1,   -1,   -1,  291,  308,   -1,  324,  311,  312,
  313,  314,   -1,   -1,   -1,  318,  319,  320,  321,  322,
   -1,   -1,  308,  310,   -1,  311,  312,  313,  314,   -1,
   -1,   -1,  318,  319,  320,  321,  322,  324,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 331
#if YYDEBUG
const char * const yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,"'\\n'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,"'!'",0,0,0,0,0,0,0,0,0,"'+'","','","'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,0,0,
"'<'","'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,"AS","ROUTERID","HOLDTIME","YMIN","LISTEN","ON","FIBUPDATE","RDE",
"EVALUATE","IGNORE","COMPARE","GROUP","NEIGHBOR","NETWORK","REMOTEAS","DESCR",
"LOCALADDR","MULTIHOP","PASSIVE","MAXPREFIX","ANNOUNCE","ENFORCE","NEIGHBORAS",
"CAPABILITIES","REFLECTOR","DEPEND","DOWN","SOFTRECONFIG","DUMP","IN","OUT",
"LOG","ROUTECOLL","TRANSPARENT","TCP","MD5SIG","PASSWORD","KEY","ALLOW","DENY",
"MATCH","QUICK","FROM","TO","ANY","CONNECTED","STATIC","PREFIX","PREFIXLEN",
"SOURCEAS","TRANSITAS","COMMUNITY","DELETE","SET","LOCALPREF","MED","METRIC",
"NEXTHOP","REJECT","BLACKHOLE","NOMODIFY","PREPEND_SELF","PREPEND_PEER",
"PFTABLE","WEIGHT","RTLABEL","ERROR","IPSEC","ESP","AH","SPI","IKE","IPV4",
"IPV6","STRING",
};
const char * const yyrule[] = {
"$accept : grammar",
"grammar :",
"grammar : grammar '\\n'",
"grammar : grammar conf_main '\\n'",
"grammar : grammar varset '\\n'",
"grammar : grammar neighbor '\\n'",
"grammar : grammar group '\\n'",
"grammar : grammar filterrule '\\n'",
"grammar : grammar error '\\n'",
"number : STRING",
"dnumber : STRING",
"asnumber : dnumber",
"string : string STRING",
"string : STRING",
"yesno : STRING",
"varset : STRING '=' string",
"conf_main : AS asnumber",
"conf_main : ROUTERID address",
"conf_main : HOLDTIME number",
"conf_main : HOLDTIME YMIN number",
"conf_main : LISTEN ON address",
"conf_main : FIBUPDATE yesno",
"conf_main : ROUTECOLL yesno",
"conf_main : TRANSPARENT yesno",
"conf_main : LOG STRING",
"conf_main : NETWORK prefix filter_set",
"conf_main : NETWORK STRING STATIC filter_set",
"conf_main : NETWORK STRING CONNECTED filter_set",
"conf_main : NETWORK STATIC filter_set",
"conf_main : NETWORK CONNECTED filter_set",
"conf_main : DUMP STRING STRING optnumber",
"conf_main : mrtdump",
"conf_main : RDE STRING EVALUATE",
"conf_main : RDE STRING IGNORE",
"conf_main : RDE MED COMPARE STRING",
"mrtdump : DUMP STRING inout STRING optnumber",
"inout : IN",
"inout : OUT",
"address : STRING",
"prefix : STRING '/' number",
"addrspec : address",
"addrspec : prefix",
"optnl : '\\n' optnl",
"optnl :",
"nl : '\\n' optnl",
"optnumber :",
"optnumber : number",
"$$1 :",
"$$2 :",
"neighbor : $$1 NEIGHBOR addrspec $$2 peeropts_h",
"$$3 :",
"group : GROUP string optnl '{' optnl $$3 groupopts_l '}'",
"groupopts_l : groupopts_l groupoptsl",
"groupopts_l : groupoptsl",
"groupoptsl : peeropts nl",
"groupoptsl : neighbor nl",
"groupoptsl : error nl",
"peeropts_h : '{' optnl peeropts_l '}'",
"peeropts_h :",
"peeropts_l : peeropts_l peeroptsl",
"peeropts_l : peeroptsl",
"peeroptsl : peeropts nl",
"peeroptsl : error nl",
"peeropts : REMOTEAS asnumber",
"peeropts : DESCR string",
"peeropts : LOCALADDR address",
"peeropts : MULTIHOP number",
"peeropts : PASSIVE",
"peeropts : DOWN",
"peeropts : HOLDTIME number",
"peeropts : HOLDTIME YMIN number",
"peeropts : ANNOUNCE family STRING",
"peeropts : ANNOUNCE STRING",
"peeropts : ENFORCE NEIGHBORAS yesno",
"peeropts : MAXPREFIX number",
"peeropts : TCP MD5SIG PASSWORD string",
"peeropts : TCP MD5SIG KEY string",
"peeropts : IPSEC espah IKE",
"peeropts : IPSEC espah inout SPI number STRING STRING encspec",
"peeropts : ANNOUNCE CAPABILITIES yesno",
"peeropts : SET filter_set_opt",
"peeropts : SET optnl '{' optnl filter_set_l optnl '}'",
"peeropts : mrtdump",
"peeropts : REFLECTOR",
"peeropts : REFLECTOR address",
"peeropts : DEPEND ON STRING",
"peeropts : SOFTRECONFIG inout yesno",
"family : IPV4",
"family : IPV6",
"espah : ESP",
"espah : AH",
"encspec :",
"encspec : STRING STRING",
"filterrule : action quick direction filter_peer_h filter_match_h filter_set",
"action : ALLOW",
"action : DENY",
"action : MATCH",
"quick :",
"quick : QUICK",
"direction : FROM",
"direction : TO",
"filter_peer_h : filter_peer",
"filter_peer_h : '{' filter_peer_l '}'",
"filter_peer_l : filter_peer",
"filter_peer_l : filter_peer_l comma filter_peer",
"filter_peer : ANY",
"filter_peer : address",
"filter_peer : GROUP STRING",
"filter_prefix_h : PREFIX filter_prefix",
"filter_prefix_h : PREFIX '{' filter_prefix_m '}'",
"filter_prefix_m : filter_prefix_l",
"filter_prefix_m : '{' filter_prefix_l '}'",
"filter_prefix_m : '{' filter_prefix_l '}' filter_prefix_m",
"filter_prefix_l : filter_prefix",
"filter_prefix_l : filter_prefix_l comma filter_prefix",
"filter_prefix : prefix",
"filter_as_h : filter_as_t",
"filter_as_h : '{' filter_as_t_l '}'",
"filter_as_t_l : filter_as_t",
"filter_as_t_l : filter_as_t_l comma filter_as_t",
"filter_as_t : filter_as_type filter_as",
"filter_as_t : filter_as_type '{' filter_as_l_h '}'",
"filter_as_l_h : filter_as_l",
"filter_as_l_h : '{' filter_as_l '}'",
"filter_as_l_h : '{' filter_as_l '}' filter_as_l_h",
"filter_as_l : filter_as",
"filter_as_l : filter_as_l comma filter_as",
"filter_as : asnumber",
"filter_match_h :",
"$$4 :",
"filter_match_h : $$4 filter_match",
"filter_match : filter_elm",
"filter_match : filter_match filter_elm",
"filter_elm : filter_prefix_h",
"filter_elm : PREFIXLEN prefixlenop",
"filter_elm : filter_as_h",
"filter_elm : COMMUNITY STRING",
"prefixlenop : unaryop number",
"prefixlenop : number binaryop number",
"filter_as_type : AS",
"filter_as_type : SOURCEAS",
"filter_as_type : TRANSITAS",
"filter_set :",
"filter_set : SET filter_set_opt",
"filter_set : SET optnl '{' optnl filter_set_l optnl '}'",
"filter_set_l : filter_set_l comma filter_set_opt",
"filter_set_l : filter_set_opt",
"delete :",
"delete : DELETE",
"filter_set_opt : LOCALPREF number",
"filter_set_opt : LOCALPREF '+' number",
"filter_set_opt : LOCALPREF '-' number",
"filter_set_opt : MED number",
"filter_set_opt : MED '+' number",
"filter_set_opt : MED '-' number",
"filter_set_opt : METRIC number",
"filter_set_opt : METRIC '+' number",
"filter_set_opt : METRIC '-' number",
"filter_set_opt : WEIGHT number",
"filter_set_opt : WEIGHT '+' number",
"filter_set_opt : WEIGHT '-' number",
"filter_set_opt : NEXTHOP address",
"filter_set_opt : NEXTHOP BLACKHOLE",
"filter_set_opt : NEXTHOP REJECT",
"filter_set_opt : NEXTHOP NOMODIFY",
"filter_set_opt : PREPEND_SELF number",
"filter_set_opt : PREPEND_PEER number",
"filter_set_opt : PFTABLE STRING",
"filter_set_opt : RTLABEL STRING",
"filter_set_opt : COMMUNITY delete STRING",
"comma : ','",
"comma :",
"unaryop : '='",
"unaryop : '!' '='",
"unaryop : '<' '='",
"unaryop : '<'",
"unaryop : '>' '='",
"unaryop : '>'",
"binaryop : '-'",
"binaryop : '>' '<'",
};
#endif
#if YYDEBUG
#include <stdio.h>
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
#line 1525 "parse.y"

struct keywords {
	const char	*k_name;
	int		 k_val;
};

int
yyerror(const char *fmt, ...)
{
	va_list		 ap;
	char		*nfmt;

	errors = 1;
	va_start(ap, fmt);
	if (asprintf(&nfmt, "%s:%d: %s", infile, yylval.lineno, fmt) == -1)
		fatalx("yyerror asprintf");
	vlog(LOG_CRIT, nfmt, ap);
	va_end(ap);
	free(nfmt);
	return (0);
}

int
kw_cmp(const void *k, const void *e)
{
	return (strcmp(k, ((const struct keywords *)e)->k_name));
}

int
lookup(char *s)
{
	/* this has to be sorted always */
	static const struct keywords keywords[] = {
		{ "AS",			AS},
		{ "IPv4",		IPV4},
		{ "IPv6",		IPV6},
		{ "ah",			AH},
		{ "allow",		ALLOW},
		{ "announce",		ANNOUNCE},
		{ "any",		ANY},
		{ "blackhole",		BLACKHOLE},
		{ "capabilities",	CAPABILITIES},
		{ "community",		COMMUNITY},
		{ "compare",		COMPARE},
		{ "connected",		CONNECTED},
		{ "delete",		DELETE},
		{ "deny",		DENY},
		{ "depend",		DEPEND},
		{ "descr",		DESCR},
		{ "down",		DOWN},
		{ "dump",		DUMP},
		{ "enforce",		ENFORCE},
		{ "esp",		ESP},
		{ "evaluate",		EVALUATE},
		{ "fib-update",		FIBUPDATE},
		{ "from",		FROM},
		{ "group",		GROUP},
		{ "holdtime",		HOLDTIME},
		{ "ignore",		IGNORE},
		{ "ike",		IKE},
		{ "in",			IN},
		{ "ipsec",		IPSEC},
		{ "key",		KEY},
		{ "listen",		LISTEN},
		{ "local-address",	LOCALADDR},
		{ "localpref",		LOCALPREF},
		{ "log",		LOG},
		{ "match",		MATCH},
		{ "max-prefix",		MAXPREFIX},
		{ "md5sig",		MD5SIG},
		{ "med",		MED},
		{ "metric",		METRIC},
		{ "min",		YMIN},
		{ "multihop",		MULTIHOP},
		{ "neighbor",		NEIGHBOR},
		{ "neighbor-as",	NEIGHBORAS},
		{ "network",		NETWORK},
		{ "nexthop",		NEXTHOP},
		{ "no-modify",		NOMODIFY},
		{ "on",			ON},
		{ "out",		OUT},
		{ "passive",		PASSIVE},
		{ "password",		PASSWORD},
		{ "pftable",		PFTABLE},
		{ "prefix",		PREFIX},
		{ "prefixlen",		PREFIXLEN},
		{ "prepend-neighbor",	PREPEND_PEER},
		{ "prepend-self",	PREPEND_SELF},
		{ "quick",		QUICK},
		{ "rde",		RDE},
		{ "reject",		REJECT},
		{ "remote-as",		REMOTEAS},
		{ "route-collector",	ROUTECOLL},
		{ "route-reflector",	REFLECTOR},
		{ "router-id",		ROUTERID},
		{ "rtlabel",		RTLABEL},
		{ "set",		SET},
		{ "softreconfig",	SOFTRECONFIG},
		{ "source-as",		SOURCEAS},
		{ "spi",		SPI},
		{ "static",		STATIC},
		{ "tcp",		TCP},
		{ "to",			TO},
		{ "transit-as",		TRANSITAS},
		{ "transparent-as",	TRANSPARENT},
		{ "weight",		WEIGHT}
	};
	const struct keywords	*p;

	p = bsearch(s, keywords, sizeof(keywords)/sizeof(keywords[0]),
	    sizeof(keywords[0]), kw_cmp);

	if (p) {
		if (pdebug > 1)
			fprintf(stderr, "%s: %d\n", s, p->k_val);
		return (p->k_val);
	} else {
		if (pdebug > 1)
			fprintf(stderr, "string: %s\n", s);
		return (STRING);
	}
}

#define MAXPUSHBACK	128

char	*parsebuf;
int	 parseindex;
char	 pushback_buffer[MAXPUSHBACK];
int	 pushback_index = 0;

int
lgetc(FILE *f)
{
	int	c, next;

	if (parsebuf) {
		/* Read character from the parsebuffer instead of input. */
		if (parseindex >= 0) {
			c = parsebuf[parseindex++];
			if (c != '\0')
				return (c);
			parsebuf = NULL;
		} else
			parseindex++;
	}

	if (pushback_index)
		return (pushback_buffer[--pushback_index]);

	while ((c = getc(f)) == '\\') {
		next = getc(f);
		if (next != '\n') {
			if (isspace(next))
				yyerror("whitespace after \\");
			ungetc(next, f);
			break;
		}
		yylval.lineno = lineno;
		lineno++;
	}
	if (c == '\t' || c == ' ') {
		/* Compress blanks to a single space. */
		do {
			c = getc(f);
		} while (c == '\t' || c == ' ');
		ungetc(c, f);
		c = ' ';
	}

	return (c);
}

int
lungetc(int c)
{
	if (c == EOF)
		return (EOF);
	if (parsebuf) {
		parseindex--;
		if (parseindex >= 0)
			return (c);
	}
	if (pushback_index < MAXPUSHBACK-1)
		return (pushback_buffer[pushback_index++] = c);
	else
		return (EOF);
}

int
findeol(void)
{
	int	c;

	parsebuf = NULL;
	pushback_index = 0;

	/* skip to either EOF or the first real EOL */
	while (1) {
		c = lgetc(fin);
		if (c == '\n') {
			lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return (ERROR);
}

int
yylex(void)
{
	char	 buf[8096];
	char	*p, *val;
	int	 endc, c;
	int	 token;

top:
	p = buf;
	while ((c = lgetc(fin)) == ' ')
		; /* nothing */

	yylval.lineno = lineno;
	if (c == '#')
		while ((c = lgetc(fin)) != '\n' && c != EOF)
			; /* nothing */
	if (c == '$' && parsebuf == NULL) {
		while (1) {
			if ((c = lgetc(fin)) == EOF)
				return (0);

			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			if (isalnum(c) || c == '_') {
				*p++ = (char)c;
				continue;
			}
			*p = '\0';
			lungetc(c);
			break;
		}
		val = symget(buf);
		if (val == NULL) {
			yyerror("macro \"%s\" not defined", buf);
			return (findeol());
		}
		parsebuf = val;
		parseindex = 0;
		goto top;
	}

	switch (c) {
	case '\'':
	case '"':
		endc = c;
		while (1) {
			if ((c = lgetc(fin)) == EOF)
				return (0);
			if (c == endc) {
				*p = '\0';
				break;
			}
			if (c == '\n') {
				lineno++;
				continue;
			}
			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			*p++ = (char)c;
		}
		yylval.v.string = strdup(buf);
		if (yylval.v.string == NULL)
			fatal("yylex: strdup");
		return (STRING);
	}

#define allowed_in_string(x) \
	(isalnum(x) || (ispunct(x) && x != '(' && x != ')' && \
	x != '{' && x != '}' && x != '<' && x != '>' && \
	x != '!' && x != '=' && x != '/' && x != '#' && \
	x != ','))

	if (isalnum(c) || c == ':' || c == '_' || c == '*') {
		do {
			*p++ = c;
			if ((unsigned)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
		} while ((c = lgetc(fin)) != EOF && (allowed_in_string(c)));
		lungetc(c);
		*p = '\0';
		if ((token = lookup(buf)) == STRING)
			if ((yylval.v.string = strdup(buf)) == NULL)
				fatal("yylex: strdup");
		return (token);
	}
	if (c == '\n') {
		yylval.lineno = lineno;
		lineno++;
	}
	if (c == EOF)
		return (0);
	return (c);
}

int
parse_config(char *filename, struct bgpd_config *xconf,
    struct mrt_head *xmconf, struct peer **xpeers, struct network_head *nc,
    struct filter_head *xfilter_l)
{
	struct sym		*sym, *next;
	struct peer		*p, *pnext;
	struct listen_addr	*la;
	struct network		*n;
	struct filter_rule	*r;

	if ((fin = fopen(filename, "r")) == NULL) {
		warn("%s", filename);
		return (-1);
	}
	infile = filename;

	if (check_file_secrecy(fileno(fin), filename)) {
		fclose(fin);
		return (-1);
	}

	if ((conf = calloc(1, sizeof(struct bgpd_config))) == NULL)
		fatal(NULL);
	if ((mrtconf = calloc(1, sizeof(struct mrt_head))) == NULL)
		fatal(NULL);
	if ((listen_addrs = calloc(1, sizeof(struct listen_addrs))) == NULL)
		fatal(NULL);
	if ((filter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	if ((peerfilter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	if ((groupfilter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	LIST_INIT(mrtconf);
	TAILQ_INIT(listen_addrs);
	TAILQ_INIT(filter_l);
	TAILQ_INIT(peerfilter_l);
	TAILQ_INIT(groupfilter_l);

	peer_l = NULL;
	peer_l_old = *xpeers;
	curpeer = NULL;
	curgroup = NULL;
	lineno = 1;
	errors = 0;
	id = 1;
	conf->opts = xconf->opts;

	/* network list is always empty in the parent */
	netconf = nc;
	TAILQ_INIT(netconf);
	/* init the empty filter list for later */
	TAILQ_INIT(xfilter_l);

	yyparse();

	fclose(fin);

	/* Free macros and check which have not been used. */
	for (sym = TAILQ_FIRST(&symhead); sym != NULL; sym = next) {
		next = TAILQ_NEXT(sym, entry);
		if ((conf->opts & BGPD_OPT_VERBOSE2) && !sym->used)
			fprintf(stderr, "warning: macro \"%s\" not "
			    "used\n", sym->nam);
		if (!sym->persist) {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	if (errors) {
		/* XXX more leaks in this case */
		while ((la = TAILQ_FIRST(listen_addrs)) != NULL) {
			TAILQ_REMOVE(listen_addrs, la, entry);
			free(la);
		}
		free(listen_addrs);

		for (p = peer_l; p != NULL; p = pnext) {
			pnext = p->next;
			free(p);
		}

		while ((n = TAILQ_FIRST(netconf)) != NULL) {
			TAILQ_REMOVE(netconf, n, entry);
			free(n);
		}

		while ((r = TAILQ_FIRST(filter_l)) != NULL) {
			TAILQ_REMOVE(filter_l, r, entry);
			free(r);
		}

		while ((r = TAILQ_FIRST(peerfilter_l)) != NULL) {
			TAILQ_REMOVE(peerfilter_l, r, entry);
			free(r);
		}

		while ((r = TAILQ_FIRST(groupfilter_l)) != NULL) {
			TAILQ_REMOVE(groupfilter_l, r, entry);
			free(r);
		}
	} else {
		errors += merge_config(xconf, conf, peer_l, listen_addrs);
		errors += mrt_mergeconfig(xmconf, mrtconf);
		*xpeers = peer_l;

		for (p = peer_l_old; p != NULL; p = pnext) {
			pnext = p->next;
			free(p);
		}

		/*
		 * Move filter list and static group and peer filtersets
		 * together. Static group sets come first then peer sets
		 * last normal filter rules.
		 */
		while ((r = TAILQ_FIRST(groupfilter_l)) != NULL) {
			TAILQ_REMOVE(groupfilter_l, r, entry);
			TAILQ_INSERT_TAIL(xfilter_l, r, entry);
		}
		while ((r = TAILQ_FIRST(peerfilter_l)) != NULL) {
			TAILQ_REMOVE(peerfilter_l, r, entry);
			TAILQ_INSERT_TAIL(xfilter_l, r, entry);
		}
		while ((r = TAILQ_FIRST(filter_l)) != NULL) {
			TAILQ_REMOVE(filter_l, r, entry);
			TAILQ_INSERT_TAIL(xfilter_l, r, entry);
		}
	}

	free(conf);
	free(mrtconf);
	free(filter_l);
	free(peerfilter_l);
	free(groupfilter_l);

	return (errors ? -1 : 0);
}

int
symset(const char *nam, const char *val, int persist)
{
	struct sym	*sym;

	for (sym = TAILQ_FIRST(&symhead); sym && strcmp(nam, sym->nam);
	    sym = TAILQ_NEXT(sym, entry))
		;	/* nothing */

	if (sym != NULL) {
		if (sym->persist == 1)
			return (0);
		else {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}
	if ((sym = calloc(1, sizeof(*sym))) == NULL)
		return (-1);

	sym->nam = strdup(nam);
	if (sym->nam == NULL) {
		free(sym);
		return (-1);
	}
	sym->val = strdup(val);
	if (sym->val == NULL) {
		free(sym->nam);
		free(sym);
		return (-1);
	}
	sym->used = 0;
	sym->persist = persist;
	TAILQ_INSERT_TAIL(&symhead, sym, entry);
	return (0);
}

int
cmdline_symset(char *s)
{
	char	*sym, *val;
	int	ret;
	size_t	len;

	if ((val = strrchr(s, '=')) == NULL)
		return (-1);

	len = strlen(s) - strlen(val) + 1;
	if ((sym = malloc(len)) == NULL)
		fatal("cmdline_symset: malloc");

	strlcpy(sym, s, len);

	ret = symset(sym, val + 1, 1);
	free(sym);

	return (ret);
}

char *
symget(const char *nam)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry)
		if (strcmp(nam, sym->nam) == 0) {
			sym->used = 1;
			return (sym->val);
		}
	return (NULL);
}

int
atoul(char *s, u_long *ulvalp)
{
	u_long	 ulval;
	char	*ep;

	errno = 0;
	ulval = strtoul(s, &ep, 0);
	if (s[0] == '\0' || *ep != '\0')
		return (-1);
	if (errno == ERANGE && ulval == ULONG_MAX)
		return (-1);
	*ulvalp = ulval;
	return (0);
}

int
getcommunity(char *s)
{
	u_long	ulval;

	if (strcmp(s, "*") == 0)
		return (COMMUNITY_ANY);
	if (strcmp(s, "neighbor-as") == 0)
		return (COMMUNITY_NEIGHBOR_AS);
	if (atoul(s, &ulval) == -1) {
		yyerror("\"%s\" is not a number", s);
		return (COMMUNITY_ERROR);
	}
	if (ulval > USHRT_MAX) {
		yyerror("Community too big: max %u", USHRT_MAX);
		return (COMMUNITY_ERROR);
	}
	return (ulval);
}

int
parsecommunity(char *s, int *as, int *type)
{
	char *p;
	int i;

	/* Well-known communities */
	if (strcasecmp(s, "NO_EXPORT") == 0) {
		*as = COMMUNITY_WELLKNOWN;
		*type = COMMUNITY_NO_EXPORT;
		return (0);
	} else if (strcasecmp(s, "NO_ADVERTISE") == 0) {
		*as = COMMUNITY_WELLKNOWN;
		*type = COMMUNITY_NO_ADVERTISE;
		return (0);
	} else if (strcasecmp(s, "NO_EXPORT_SUBCONFED") == 0) {
		*as = COMMUNITY_WELLKNOWN;
		*type = COMMUNITY_NO_EXPSUBCONFED;
		return (0);
	} else if (strcasecmp(s, "NO_PEER") == 0) {
		*as = COMMUNITY_WELLKNOWN;
		*type = COMMUNITY_NO_PEER;
		return (0);
	}

	if ((p = strchr(s, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*p++ = 0;

	if ((i = getcommunity(s)) == COMMUNITY_ERROR)
		return (-1);
	if (i == 0 || i == USHRT_MAX) {
		yyerror("Bad community AS number");
		return (-1);
	}
	*as = i;

	if ((i = getcommunity(p)) == COMMUNITY_ERROR)
		return (-1);
	*type = i;

	return (0);
}

struct peer *
alloc_peer(void)
{
	struct peer	*p;

	if ((p = calloc(1, sizeof(struct peer))) == NULL)
		fatal("new_peer");

	/* some sane defaults */
	p->state = STATE_NONE;
	p->next = NULL;
	p->conf.distance = 1;
	p->conf.announce_type = ANNOUNCE_UNDEF;
	p->conf.announce_capa = 1;
	p->conf.capabilities.mp_v4 = SAFI_UNICAST;
	p->conf.capabilities.mp_v6 = SAFI_NONE;
	p->conf.capabilities.refresh = 1;
	p->conf.capabilities.as_4bytes = 1;
	p->conf.softreconfig_in = 1;
	p->conf.softreconfig_out = 1;

	return (p);
}

struct peer *
new_peer(void)
{
	struct peer		*p;

	p = alloc_peer();

	if (curgroup != NULL) {
		memcpy(p, curgroup, sizeof(struct peer));
		if (strlcpy(p->conf.group, curgroup->conf.group,
		    sizeof(p->conf.group)) >= sizeof(p->conf.group))
			fatalx("new_peer group strlcpy");
		if (strlcpy(p->conf.descr, curgroup->conf.descr,
		    sizeof(p->conf.descr)) >= sizeof(p->conf.descr))
			fatalx("new_peer descr strlcpy");
		p->conf.groupid = curgroup->conf.id;
	}
	p->next = NULL;

	return (p);
}

struct peer *
new_group(void)
{
	return (alloc_peer());
}

int
add_mrtconfig(enum mrt_type type, char *name, time_t timeout, struct peer *p)
{
	struct mrt	*m, *n;

	LIST_FOREACH(m, mrtconf, entry) {
		if (p == NULL) {
			if (m->peer_id != 0 || m->group_id != 0)
				continue;
		} else {
			if (m->peer_id != p->conf.id ||
			    m->group_id != p->conf.groupid)
				continue;
		}
		if (m->type == type) {
			yyerror("only one mrtdump per type allowed.");
			return (-1);
		}
	}

	if ((n = calloc(1, sizeof(struct mrt_config))) == NULL)
		fatal("add_mrtconfig");

	n->type = type;
	if (strlcpy(MRT2MC(n)->name, name, sizeof(MRT2MC(n)->name)) >=
	    sizeof(MRT2MC(n)->name)) {
		yyerror("filename \"%s\" too long: max %u",
		    name, sizeof(MRT2MC(n)->name) - 1);
		free(n);
		return (-1);
	}
	MRT2MC(n)->ReopenTimerInterval = timeout;
	if (p != NULL) {
		if (curgroup == p) {
			n->peer_id = 0;
			n->group_id = p->conf.id;
		} else {
			n->peer_id = p->conf.id;
			n->group_id = 0;
		}
	}

	LIST_INSERT_HEAD(mrtconf, n, entry);

	return (0);
}

int
get_id(struct peer *newpeer)
{
	struct peer	*p;

	if (newpeer->conf.remote_addr.af)
		for (p = peer_l_old; p != NULL; p = p->next)
			if (!memcmp(&p->conf.remote_addr,
			    &newpeer->conf.remote_addr,
			    sizeof(p->conf.remote_addr))) {
				newpeer->conf.id = p->conf.id;
				return (0);
			}

	/* new one */
	for (; id < UINT_MAX / 2; id++) {
		for (p = peer_l_old; p != NULL && p->conf.id != id; p = p->next)
			;	/* nothing */
		if (p == NULL) {	/* we found a free id */
			newpeer->conf.id = id++;
			return (0);
		}
	}

	return (-1);
}

int
expand_rule(struct filter_rule *rule, struct filter_peers_l *peer,
    struct filter_match_l *match, struct filter_set_head *set)
{
	struct filter_rule	*r;
	struct filter_peers_l	*p, *pnext;
	struct filter_prefix_l	*prefix, *prefix_next;
	struct filter_as_l	*a, *anext;
	struct filter_set	*s;

	p = peer;
	do {
		prefix = match->prefix_l;
		do {
			a = match->as_l;
			do {
				if ((r = calloc(1,
				    sizeof(struct filter_rule))) == NULL) {
					log_warn("expand_rule");
					return (-1);
				}

				memcpy(r, rule, sizeof(struct filter_rule));
				memcpy(&r->match, match,
				    sizeof(struct filter_match));
				TAILQ_INIT(&r->set);
				copy_filterset(set, &r->set);

				if (p != NULL)
					memcpy(&r->peer, &p->p,
					    sizeof(struct filter_peers));

				if (prefix != NULL)
					memcpy(&r->match.prefix, &prefix->p,
					    sizeof(r->match.prefix));

				if (a != NULL)
					memcpy(&r->match.as, &a->a,
					    sizeof(struct filter_as));

				TAILQ_INSERT_TAIL(filter_l, r, entry);

				if (a != NULL)
					a = a->next;
			} while (a != NULL);

			if (prefix != NULL)
				prefix = prefix->next;
		} while (prefix != NULL);

		if (p != NULL)
			p = p->next;
	} while (p != NULL);

	for (p = peer; p != NULL; p = pnext) {
		pnext = p->next;
		free(p);
	}

	for (prefix = match->prefix_l; prefix != NULL; prefix = prefix_next) {
		prefix_next = prefix->next;
		free(prefix);
	}

	for (a = match->as_l; a != NULL; a = anext) {
		anext = a->next;
		free(a);
	}

	if (set != NULL) {
		while ((s = TAILQ_FIRST(set)) != NULL) {
			TAILQ_REMOVE(set, s, entry);
			free(s);
		}
		free(set);
	}

	return (0);
}

int
str2key(char *s, char *dest, size_t max_len)
{
	unsigned	i;
	char		t[3];

	if (strlen(s) / 2 > max_len) {
		yyerror("key too long");
		return (-1);
	}

	if (strlen(s) % 2) {
		yyerror("key must be of even length");
		return (-1);
	}

	for (i = 0; i < strlen(s) / 2; i++) {
		t[0] = s[2*i];
		t[1] = s[2*i + 1];
		t[2] = 0;
		if (!isxdigit(t[0]) || !isxdigit(t[1])) {
			yyerror("key must be specified in hex");
			return (-1);
		}
		dest[i] = strtoul(t, NULL, 16);
	}

	return (0);
}

int
neighbor_consistent(struct peer *p)
{
	/* local-address and peer's address: same address family */
	if (p->conf.local_addr.af &&
	    p->conf.local_addr.af != p->conf.remote_addr.af) {
		yyerror("local-address and neighbor address "
		    "must be of the same address family");
		return (-1);
	}

	/* with any form of ipsec local-address is required */
	if ((p->conf.auth.method == AUTH_IPSEC_IKE_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_IKE_AH ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_AH) &&
	    !p->conf.local_addr.af) {
		yyerror("neighbors with any form of IPsec configured "
		    "need local-address to be specified");
		return (-1);
	}

	/* with static keying we need both directions */
	if ((p->conf.auth.method == AUTH_IPSEC_MANUAL_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_AH) &&
	    (!p->conf.auth.spi_in || !p->conf.auth.spi_out)) {
		yyerror("with manual keyed IPsec, SPIs and keys "
		    "for both directions are required");
		return (-1);
	}

	if (!conf->as) {
		yyerror("AS needs to be given before neighbor definitions");
		return (-1);
	}

	/* set default values if they where undefined */
	p->conf.ebgp = (p->conf.remote_as != conf->as);
	if (p->conf.announce_type == ANNOUNCE_UNDEF)
		p->conf.announce_type = p->conf.ebgp == 0 ?
		    ANNOUNCE_ALL : ANNOUNCE_SELF;
	if (p->conf.enforce_as == ENFORCE_AS_UNDEF)
		p->conf.enforce_as = p->conf.ebgp == 0 ?
		    ENFORCE_AS_OFF : ENFORCE_AS_ON;

	/* EBGP neighbors are not allowed in route reflector clusters */
	if (p->conf.reflector_client && p->conf.ebgp) {
		yyerror("EBGP neighbors are not allowed in route "
		    "reflector clusters");
		return (-1);
	}

	return (0);
}

int
merge_filterset(struct filter_set_head *sh, struct filter_set *s)
{
	struct filter_set	*t;

	TAILQ_FOREACH(t, sh, entry) {
		/*
		 * need to cycle across the full list because even
		 * if types are not equal filterset_cmp() may return 0.
		 */
		if (filterset_cmp(s, t) == 0) {
			if (s->type == ACTION_SET_COMMUNITY)
				yyerror("community is already set");
			else
				yyerror("redefining set parameter %s",
				    filterset_names[s->type]);
			return (-1);
		}
	}

	TAILQ_FOREACH(t, sh, entry) {
		if (s->type < t->type) {
			TAILQ_INSERT_BEFORE(t, s, entry);
			return (0);
		}
		if (s->type == t->type)
			switch (s->type) {
			case ACTION_SET_COMMUNITY:
				if (s->action.community.as <
				    t->action.community.as ||
				    (s->action.community.as ==
				    t->action.community.as &&
				    s->action.community.type <
				    t->action.community.type)) {
					TAILQ_INSERT_BEFORE(t, s, entry);
					return (0);
				}
				break;
			case ACTION_SET_NEXTHOP:
				if (s->action.nexthop.af <
				    t->action.nexthop.af) {
					TAILQ_INSERT_BEFORE(t, s, entry);
					return (0);
				}
				break;
			default:
				break;
			}
	}

	TAILQ_INSERT_TAIL(sh, s, entry);
	return (0);
}

void
copy_filterset(struct filter_set_head *source, struct filter_set_head *dest)
{
	struct filter_set	*s, *t;

	if (source == NULL)
		return;

	TAILQ_FOREACH(s, source, entry) {
		if ((t = calloc(1, sizeof(struct filter_set))) == NULL)
			fatal(NULL);
		memcpy(t, s, sizeof(struct filter_set));
		TAILQ_INSERT_TAIL(dest, t, entry);
	}
}

void
move_filterset(struct filter_set_head *source, struct filter_set_head *dest)
{
	struct filter_set	*s;

	TAILQ_INIT(dest);

	if (source == NULL)
		return;

	while ((s = TAILQ_FIRST(source)) != NULL) {
		TAILQ_REMOVE(source, s, entry);
		TAILQ_INSERT_TAIL(dest, s, entry);
	}
}

struct filter_rule *
get_rule(enum action_types type)
{
	struct filter_rule	*r;
	int			 out;

	switch (type) {
	case ACTION_SET_PREPEND_SELF:
	case ACTION_SET_NEXTHOP_NOMODIFY:
		out = 1;
		break;
	default:
		out = 0;
		break;
	}
	r = (curpeer == curgroup) ? curgroup_filter[out] : curpeer_filter[out];
	if (r == NULL) {
		if ((r = calloc(1, sizeof(struct filter_rule))) == NULL)
			fatal(NULL);
		r->quick = 0;
		r->dir = out ? DIR_OUT : DIR_IN;
		r->action = ACTION_NONE;
		TAILQ_INIT(&r->set);
		if (curpeer == curgroup) {
			/* group */
			r->peer.groupid = curgroup->conf.id;
			curgroup_filter[out] = r;
		} else {
			/* peer */
			r->peer.peerid = curpeer->conf.id;
			curpeer_filter[out] = r;
		}
	}
	return (r);
}
#line 1770 "parse.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack()
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss);
    if (newss == NULL)
        return -1;
    yyss = newss;
    yyssp = newss + i;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs);
    if (newvs == NULL)
        return -1;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab

#ifndef YYPARSE_PARAM
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG void
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif	/* ANSI-C/C++ */
#else	/* YYPARSE_PARAM */
#ifndef YYPARSE_PARAM_TYPE
#define YYPARSE_PARAM_TYPE void *
#endif
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG YYPARSE_PARAM_TYPE YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL YYPARSE_PARAM_TYPE YYPARSE_PARAM;
#endif	/* ANSI-C/C++ */
#endif	/* ! YYPARSE_PARAM */

int
yyparse (YYPARSE_PARAM_ARG)
    YYPARSE_PARAM_DECL
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate])) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(lint) || defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(lint) || defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 8:
#line 195 "parse.y"
{ errors++; }
break;
case 9:
#line 199 "parse.y"
{
                 u_long	ulval;

			if (atoul(yyvsp[0].v.string, &ulval) == -1) {
				yyerror("\"%s\" is not a number", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			} else
				yyval.v.number = ulval;
			free(yyvsp[0].v.string);
		}
break;
case 10:
#line 212 "parse.y"
{
                 u_long	ulval, ulval2;
                 char *dot ;

		 if ((dot = strchr(yyvsp[0].v.string,'.')) != NULL) {
                   *dot = '\0';
                   ++dot ; 
                   if (atoul(dot,&ulval2) == -1) {
				yyerror("\"%s\" is not a number", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
		                }
		   else if (atoul(yyvsp[0].v.string, &ulval) == -1) {
				yyerror("\"%s\" is not a number", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
		                }
		   else
                     yyval.v.number = (ulval << 16) + ulval2 ;
		   }
                 else 
			if (atoul(yyvsp[0].v.string, &ulval) == -1) {
				yyerror("\"%s\" is not a number", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			} else
				yyval.v.number = ulval;
			free(yyvsp[0].v.string);
		}
break;
case 11:
#line 243 "parse.y"
{
			if (yyvsp[0].v.number > ULONG_MAX) {
				yyerror("AS too big: max %u", ULONG_MAX);
				YYERROR;
			}

                }
break;
case 12:
#line 251 "parse.y"
{
			if (asprintf(&yyval.v.string, "%s %s", yyvsp[-1].v.string, yyvsp[0].v.string) == -1)
				fatal("string: asprintf");
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 14:
#line 260 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "yes"))
				yyval.v.number = 1;
			else if (!strcmp(yyvsp[0].v.string, "no"))
				yyval.v.number = 0;
			else {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 15:
#line 273 "parse.y"
{
			if (conf->opts & BGPD_OPT_VERBOSE)
				printf("%s = \"%s\"\n", yyvsp[-2].v.string, yyvsp[0].v.string);
			if (symset(yyvsp[-2].v.string, yyvsp[0].v.string, 0) == -1)
				fatal("cannot store variable");
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 16:
#line 283 "parse.y"
{
			conf->as = yyvsp[0].v.number;
		}
break;
case 17:
#line 286 "parse.y"
{
			if (yyvsp[0].v.addr.af != AF_INET) {
				yyerror("router-id must be an IPv4 address");
				YYERROR;
			}
			conf->bgpid = yyvsp[0].v.addr.v4.s_addr;
		}
break;
case 18:
#line 293 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME) {
				yyerror("holdtime must be at least %u",
				    MIN_HOLDTIME);
				YYERROR;
			}
			conf->holdtime = yyvsp[0].v.number;
		}
break;
case 19:
#line 301 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME) {
				yyerror("holdtime min must be at least %u",
				    MIN_HOLDTIME);
				YYERROR;
			}
			conf->min_holdtime = yyvsp[0].v.number;
		}
break;
case 20:
#line 309 "parse.y"
{
			struct listen_addr	*la;
			struct sockaddr_in	*in;
			struct sockaddr_in6	*in6;

			if ((la = calloc(1, sizeof(struct listen_addr))) ==
			    NULL)
				fatal("parse conf_main listen on calloc");

			la->fd = -1;
			la->sa.ss_family = yyvsp[0].v.addr.af;
			switch (yyvsp[0].v.addr.af) {
			case AF_INET:
				la->sa.ss_len = sizeof(struct sockaddr_in);
				in = (struct sockaddr_in *)&la->sa;
				in->sin_addr.s_addr = yyvsp[0].v.addr.v4.s_addr;
				in->sin_port = htons(BGP_PORT);
				break;
			case AF_INET6:
				la->sa.ss_len = sizeof(struct sockaddr_in6);
				in6 = (struct sockaddr_in6 *)&la->sa;
				memcpy(&in6->sin6_addr, &yyvsp[0].v.addr.v6,
				    sizeof(in6->sin6_addr));
				in6->sin6_port = htons(BGP_PORT);
				break;
			default:
				yyerror("king bula does not like family %u",
				    yyvsp[0].v.addr.af);
				YYERROR;
			}

			TAILQ_INSERT_TAIL(listen_addrs, la, entry);
		}
break;
case 21:
#line 342 "parse.y"
{
			if (yyvsp[0].v.number == 0)
				conf->flags |= BGPD_FLAG_NO_FIB_UPDATE;
			else
				conf->flags &= ~BGPD_FLAG_NO_FIB_UPDATE;
		}
break;
case 22:
#line 348 "parse.y"
{
			if (yyvsp[0].v.number == 1)
				conf->flags |= BGPD_FLAG_NO_EVALUATE;
			else
				conf->flags &= ~BGPD_FLAG_NO_EVALUATE;
		}
break;
case 23:
#line 354 "parse.y"
{
			if (yyvsp[0].v.number == 1)
				conf->flags |= BGPD_FLAG_DECISION_TRANS_AS;
			else
				conf->flags &= ~BGPD_FLAG_DECISION_TRANS_AS;
		}
break;
case 24:
#line 360 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "updates"))
				conf->log |= BGPD_LOG_UPDATES;
			else {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 25:
#line 369 "parse.y"
{
			struct network	*n;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			memcpy(&n->net.prefix, &yyvsp[-1].v.prefix.prefix,
			    sizeof(n->net.prefix));
			n->net.prefixlen = yyvsp[-1].v.prefix.len;
			move_filterset(yyvsp[0].v.filter_set_head, &n->net.attrset);
			free(yyvsp[0].v.filter_set_head);

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
break;
case 26:
#line 382 "parse.y"
{
			if (!strcmp(yyvsp[-2].v.string, "inet")) {
				conf->flags |= BGPD_FLAG_REDIST_STATIC;
				move_filterset(yyvsp[0].v.filter_set_head, &conf->staticset);
			} else if (!strcmp(yyvsp[-2].v.string, "inet6")) {
				conf->flags |= BGPD_FLAG_REDIST6_STATIC;
				move_filterset(yyvsp[0].v.filter_set_head, &conf->staticset6);
			}
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.filter_set_head);
		}
break;
case 27:
#line 393 "parse.y"
{
			if (!strcmp(yyvsp[-2].v.string, "inet")) {
				conf->flags |= BGPD_FLAG_REDIST_CONNECTED;
				move_filterset(yyvsp[0].v.filter_set_head, &conf->connectset);
			} else if (!strcmp(yyvsp[-2].v.string, "inet6")) {
				conf->flags |= BGPD_FLAG_REDIST6_CONNECTED;
				move_filterset(yyvsp[0].v.filter_set_head, &conf->connectset6);
			}
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.filter_set_head);
		}
break;
case 28:
#line 404 "parse.y"
{
			/* keep for compatibility till after next release */
			conf->flags |= BGPD_FLAG_REDIST_STATIC;
			move_filterset(yyvsp[0].v.filter_set_head, &conf->staticset);
			free(yyvsp[0].v.filter_set_head);
		}
break;
case 29:
#line 410 "parse.y"
{
			/* keep for compatibility till after next release */
			conf->flags |= BGPD_FLAG_REDIST_CONNECTED;
			move_filterset(yyvsp[0].v.filter_set_head, &conf->connectset);
			free(yyvsp[0].v.filter_set_head);
		}
break;
case 30:
#line 416 "parse.y"
{
			int action;

			if (!strcmp(yyvsp[-2].v.string, "table"))
				action = MRT_TABLE_DUMP;
			else if (!strcmp(yyvsp[-2].v.string, "table-mp"))
				action = MRT_TABLE_DUMP_MP;
			else {
				yyerror("unknown mrt dump type");
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
			if (add_mrtconfig(action, yyvsp[-1].v.string, yyvsp[0].v.number, NULL) == -1) {
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 32:
#line 437 "parse.y"
{
			if (!strcmp(yyvsp[-1].v.string, "route-age"))
				conf->flags |= BGPD_FLAG_DECISION_ROUTEAGE;
			else {
				yyerror("unknown route decision type");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 33:
#line 447 "parse.y"
{
			if (!strcmp(yyvsp[-1].v.string, "route-age"))
				conf->flags &= ~BGPD_FLAG_DECISION_ROUTEAGE;
			else {
				yyerror("unknown route decision type");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 34:
#line 457 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "always"))
				conf->flags |= BGPD_FLAG_DECISION_MED_ALWAYS;
			else if (!strcmp(yyvsp[0].v.string, "strict"))
				conf->flags &= ~BGPD_FLAG_DECISION_MED_ALWAYS;
			else {
				yyerror("rde med compare: "
				    "unknown setting \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 35:
#line 472 "parse.y"
{
			int action;

			if (!strcmp(yyvsp[-3].v.string, "all"))
				action = yyvsp[-2].v.number ? MRT_ALL_IN : MRT_ALL_OUT;
			else if (!strcmp(yyvsp[-3].v.string, "updates"))
				action = yyvsp[-2].v.number ? MRT_UPDATE_IN : MRT_UPDATE_OUT;
			else {
				yyerror("unknown mrt msg dump type");
				free(yyvsp[-3].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (add_mrtconfig(action, yyvsp[-1].v.string, yyvsp[0].v.number, curpeer) == -1) {
				free(yyvsp[-3].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
			free(yyvsp[-1].v.string);
		}
break;
case 36:
#line 495 "parse.y"
{ yyval.v.number = 1; }
break;
case 37:
#line 496 "parse.y"
{ yyval.v.number = 0; }
break;
case 38:
#line 499 "parse.y"
{
			u_int8_t	len;

			if (!host(yyvsp[0].v.string, &yyval.v.addr, &len)) {
				yyerror("could not parse address spec \"%s\"",
				    yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);

			if ((yyval.v.addr.af == AF_INET && len != 32) ||
			    (yyval.v.addr.af == AF_INET6 && len != 128)) {
				/* unreachable */
				yyerror("got prefixlen %u, expected %u",
				    len, yyval.v.addr.af == AF_INET ? 32 : 128);
				YYERROR;
			}
		}
break;
case 39:
#line 520 "parse.y"
{
			char	*s;

			if (asprintf(&s, "%s/%u", yyvsp[-2].v.string, yyvsp[0].v.number) == -1)
				fatal(NULL);
			free(yyvsp[-2].v.string);

			if (!host(s, &yyval.v.prefix.prefix, &yyval.v.prefix.len)) {
				yyerror("could not parse address \"%s\"", s);
				free(s);
				YYERROR;
			}
			free(s);
		}
break;
case 40:
#line 536 "parse.y"
{
			memcpy(&yyval.v.prefix.prefix, &yyvsp[0].v.addr, sizeof(struct bgpd_addr));
			if (yyval.v.prefix.prefix.af == AF_INET)
				yyval.v.prefix.len = 32;
			else
				yyval.v.prefix.len = 128;
		}
break;
case 45:
#line 553 "parse.y"
{ yyval.v.number = 0; }
break;
case 47:
#line 557 "parse.y"
{	curpeer = new_peer(); }
break;
case 48:
#line 558 "parse.y"
{
			memcpy(&curpeer->conf.remote_addr, &yyvsp[0].v.prefix.prefix,
			    sizeof(curpeer->conf.remote_addr));
			curpeer->conf.remote_masklen = yyvsp[0].v.prefix.len;
			if ((yyvsp[0].v.prefix.prefix.af == AF_INET && yyvsp[0].v.prefix.len != 32) ||
			    (yyvsp[0].v.prefix.prefix.af == AF_INET6 && yyvsp[0].v.prefix.len != 128))
				curpeer->conf.template = 1;
			if (get_id(curpeer)) {
				yyerror("get_id failed");
				YYERROR;
			}
		}
break;
case 49:
#line 570 "parse.y"
{
			if (curpeer_filter[0] != NULL)
				TAILQ_INSERT_TAIL(peerfilter_l,
				    curpeer_filter[0], entry);
			if (curpeer_filter[1] != NULL)
				TAILQ_INSERT_TAIL(peerfilter_l,
				    curpeer_filter[1], entry);
			curpeer_filter[0] = NULL;
			curpeer_filter[1] = NULL;

			if (neighbor_consistent(curpeer) == -1)
				YYERROR;
			curpeer->next = peer_l;
			peer_l = curpeer;
			curpeer = curgroup;
		}
break;
case 50:
#line 588 "parse.y"
{
			curgroup = curpeer = new_group();
			if (strlcpy(curgroup->conf.group, yyvsp[-3].v.string,
			    sizeof(curgroup->conf.group)) >=
			    sizeof(curgroup->conf.group)) {
				yyerror("group name \"%s\" too long: max %u",
				    yyvsp[-3].v.string, sizeof(curgroup->conf.group) - 1);
				free(yyvsp[-3].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
			if (get_id(curgroup)) {
				yyerror("get_id failed");
				YYERROR;
			}
		}
break;
case 51:
#line 604 "parse.y"
{
			if (curgroup_filter[0] != NULL)
				TAILQ_INSERT_TAIL(groupfilter_l,
				    curgroup_filter[0], entry);
			if (curgroup_filter[1] != NULL)
				TAILQ_INSERT_TAIL(groupfilter_l,
				    curgroup_filter[1], entry);
			curgroup_filter[0] = NULL;
			curgroup_filter[1] = NULL;

			free(curgroup);
			curgroup = NULL;
		}
break;
case 63:
#line 640 "parse.y"
{
			curpeer->conf.remote_as = yyvsp[0].v.number;
		}
break;
case 64:
#line 643 "parse.y"
{
			if (strlcpy(curpeer->conf.descr, yyvsp[0].v.string,
			    sizeof(curpeer->conf.descr)) >=
			    sizeof(curpeer->conf.descr)) {
				yyerror("descr \"%s\" too long: max %u",
				    yyvsp[0].v.string, sizeof(curpeer->conf.descr) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 65:
#line 654 "parse.y"
{
			memcpy(&curpeer->conf.local_addr, &yyvsp[0].v.addr,
			    sizeof(curpeer->conf.local_addr));
		}
break;
case 66:
#line 658 "parse.y"
{
			if (yyvsp[0].v.number < 2 || yyvsp[0].v.number > 255) {
				yyerror("invalid multihop distance %d", yyvsp[0].v.number);
				YYERROR;
			}
			curpeer->conf.distance = yyvsp[0].v.number;
		}
break;
case 67:
#line 665 "parse.y"
{
			curpeer->conf.passive = 1;
		}
break;
case 68:
#line 668 "parse.y"
{
			curpeer->conf.down = 1;
		}
break;
case 69:
#line 671 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME) {
				yyerror("holdtime must be at least %u",
				    MIN_HOLDTIME);
				YYERROR;
			}
			curpeer->conf.holdtime = yyvsp[0].v.number;
		}
break;
case 70:
#line 679 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME) {
				yyerror("holdtime min must be at least %u",
				    MIN_HOLDTIME);
				YYERROR;
			}
			curpeer->conf.min_holdtime = yyvsp[0].v.number;
		}
break;
case 71:
#line 687 "parse.y"
{
			u_int8_t	safi;

			if (!strcmp(yyvsp[0].v.string, "none"))
				safi = SAFI_NONE;
			else if (!strcmp(yyvsp[0].v.string, "unicast"))
				safi = SAFI_UNICAST;
			else {
				yyerror("unknown/unsupported SAFI \"%s\"",
				    yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);

			switch (yyvsp[-1].v.number) {
			case AFI_IPv4:
				curpeer->conf.capabilities.mp_v4 = safi;
				break;
			case AFI_IPv6:
				curpeer->conf.capabilities.mp_v6 = safi;
				break;
			default:
				fatal("king bula sees borked AFI");
			}
		}
break;
case 72:
#line 713 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "self"))
				curpeer->conf.announce_type = ANNOUNCE_SELF;
			else if (!strcmp(yyvsp[0].v.string, "none"))
				curpeer->conf.announce_type = ANNOUNCE_NONE;
			else if (!strcmp(yyvsp[0].v.string, "all"))
				curpeer->conf.announce_type = ANNOUNCE_ALL;
			else if (!strcmp(yyvsp[0].v.string, "default-route"))
				curpeer->conf.announce_type =
				    ANNOUNCE_DEFAULT_ROUTE;
			else {
				yyerror("invalid announce type");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 73:
#line 730 "parse.y"
{
			if (yyvsp[0].v.number)
				curpeer->conf.enforce_as = ENFORCE_AS_ON;
			else
				curpeer->conf.enforce_as = ENFORCE_AS_OFF;
		}
break;
case 74:
#line 736 "parse.y"
{
			curpeer->conf.max_prefix = yyvsp[0].v.number;
		}
break;
case 75:
#line 739 "parse.y"
{
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (strlcpy(curpeer->conf.auth.md5key, yyvsp[0].v.string,
			    sizeof(curpeer->conf.auth.md5key)) >=
			    sizeof(curpeer->conf.auth.md5key)) {
				yyerror("tcp md5sig password too long: max %u",
				    sizeof(curpeer->conf.auth.md5key) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			curpeer->conf.auth.method = AUTH_MD5SIG;
			curpeer->conf.auth.md5key_len = strlen(yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 76:
#line 757 "parse.y"
{
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				free(yyvsp[0].v.string);
				YYERROR;
			}

			if (str2key(yyvsp[0].v.string, curpeer->conf.auth.md5key,
			    sizeof(curpeer->conf.auth.md5key)) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			curpeer->conf.auth.method = AUTH_MD5SIG;
			curpeer->conf.auth.md5key_len = strlen(yyvsp[0].v.string) / 2;
			free(yyvsp[0].v.string);
		}
break;
case 77:
#line 773 "parse.y"
{
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				YYERROR;
			}
			if (yyvsp[-1].v.number)
				curpeer->conf.auth.method = AUTH_IPSEC_IKE_ESP;
			else
				curpeer->conf.auth.method = AUTH_IPSEC_IKE_AH;
		}
break;
case 78:
#line 783 "parse.y"
{
			u_int32_t	auth_alg;
			u_int8_t	keylen;

			if (curpeer->conf.auth.method &&
			    (((curpeer->conf.auth.spi_in && yyvsp[-5].v.number == 1) ||
			    (curpeer->conf.auth.spi_out && yyvsp[-5].v.number == 0)) ||
			    (yyvsp[-6].v.number == 1 && curpeer->conf.auth.method !=
			    AUTH_IPSEC_MANUAL_ESP) ||
			    (yyvsp[-6].v.number == 0 && curpeer->conf.auth.method !=
			    AUTH_IPSEC_MANUAL_AH))) {
				yyerror("auth method cannot be redefined");
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}

			if (!strcmp(yyvsp[-2].v.string, "sha1")) {
				auth_alg = SADB_AALG_SHA1HMAC;
				keylen = 20;
			} else if (!strcmp(yyvsp[-2].v.string, "md5")) {
				auth_alg = SADB_AALG_MD5HMAC;
				keylen = 16;
			} else {
				yyerror("unknown auth algorithm \"%s\"", yyvsp[-2].v.string);
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);

			if (strlen(yyvsp[-1].v.string) / 2 != keylen) {
				yyerror("auth key len: must be %u bytes, "
				    "is %u bytes", keylen, strlen(yyvsp[-1].v.string) / 2);
				free(yyvsp[-1].v.string);
				YYERROR;
			}

			if (yyvsp[-6].v.number)
				curpeer->conf.auth.method =
				    AUTH_IPSEC_MANUAL_ESP;
			else {
				if (yyvsp[0].v.encspec.enc_alg) {
					yyerror("\"ipsec ah\" doesn't take "
					    "encryption keys");
					free(yyvsp[-1].v.string);
					YYERROR;
				}
				curpeer->conf.auth.method =
				    AUTH_IPSEC_MANUAL_AH;
			}

			if (yyvsp[-5].v.number == 1) {
				if (str2key(yyvsp[-1].v.string, curpeer->conf.auth.auth_key_in,
				    sizeof(curpeer->conf.auth.auth_key_in)) ==
				    -1) {
					free(yyvsp[-1].v.string);
					YYERROR;
				}
				curpeer->conf.auth.spi_in = yyvsp[-3].v.number;
				curpeer->conf.auth.auth_alg_in = auth_alg;
				curpeer->conf.auth.enc_alg_in = yyvsp[0].v.encspec.enc_alg;
				memcpy(&curpeer->conf.auth.enc_key_in,
				    &yyvsp[0].v.encspec.enc_key,
				    sizeof(curpeer->conf.auth.enc_key_in));
				curpeer->conf.auth.enc_keylen_in =
				    yyvsp[0].v.encspec.enc_key_len;
				curpeer->conf.auth.auth_keylen_in = keylen;
			} else {
				if (str2key(yyvsp[-1].v.string, curpeer->conf.auth.auth_key_out,
				    sizeof(curpeer->conf.auth.auth_key_out)) ==
				    -1) {
					free(yyvsp[-1].v.string);
					YYERROR;
				}
				curpeer->conf.auth.spi_out = yyvsp[-3].v.number;
				curpeer->conf.auth.auth_alg_out = auth_alg;
				curpeer->conf.auth.enc_alg_out = yyvsp[0].v.encspec.enc_alg;
				memcpy(&curpeer->conf.auth.enc_key_out,
				    &yyvsp[0].v.encspec.enc_key,
				    sizeof(curpeer->conf.auth.enc_key_out));
				curpeer->conf.auth.enc_keylen_out =
				    yyvsp[0].v.encspec.enc_key_len;
				curpeer->conf.auth.auth_keylen_out = keylen;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 79:
#line 870 "parse.y"
{
			curpeer->conf.announce_capa = yyvsp[0].v.number;
		}
break;
case 80:
#line 873 "parse.y"
{
			struct filter_rule	*r;

			r = get_rule(yyvsp[0].v.filter_set->type);
			if (merge_filterset(&r->set, yyvsp[0].v.filter_set) == -1)
				YYERROR;
		}
break;
case 81:
#line 880 "parse.y"
{
			struct filter_rule	*r;
			struct filter_set	*s;

			while ((s = TAILQ_FIRST(yyvsp[-2].v.filter_set_head)) != NULL) {
				TAILQ_REMOVE(yyvsp[-2].v.filter_set_head, s, entry);
				r = get_rule(s->type);
				if (merge_filterset(&r->set, s) == -1)
					YYERROR;
			}
			free(yyvsp[-2].v.filter_set_head);
		}
break;
case 83:
#line 893 "parse.y"
{
			if ((conf->flags & BGPD_FLAG_REFLECTOR) &&
			    conf->clusterid != 0) {
				yyerror("only one route reflector "
				    "cluster allowed");
				YYERROR;
			}
			conf->flags |= BGPD_FLAG_REFLECTOR;
			curpeer->conf.reflector_client = 1;
		}
break;
case 84:
#line 903 "parse.y"
{
			if (yyvsp[0].v.addr.af != AF_INET) {
				yyerror("route reflector cluster-id must be "
				    "an IPv4 address");
				YYERROR;
			}
			if ((conf->flags & BGPD_FLAG_REFLECTOR) &&
			    conf->clusterid != yyvsp[0].v.addr.v4.s_addr) {
				yyerror("only one route reflector "
				    "cluster allowed");
				YYERROR;
			}
			conf->flags |= BGPD_FLAG_REFLECTOR;
			curpeer->conf.reflector_client = 1;
			conf->clusterid = yyvsp[0].v.addr.v4.s_addr;
		}
break;
case 85:
#line 919 "parse.y"
{
			if (strlcpy(curpeer->conf.if_depend, yyvsp[0].v.string,
			    sizeof(curpeer->conf.if_depend)) >=
			    sizeof(curpeer->conf.if_depend)) {
				yyerror("interface name \"%s\" too long: "
				    "max %u", yyvsp[0].v.string,
				    sizeof(curpeer->conf.if_depend) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 86:
#line 931 "parse.y"
{
			if (yyvsp[-1].v.number)
				curpeer->conf.softreconfig_in = yyvsp[0].v.number;
			else
				curpeer->conf.softreconfig_out = yyvsp[0].v.number;
		}
break;
case 87:
#line 939 "parse.y"
{ yyval.v.number = AFI_IPv4; }
break;
case 88:
#line 940 "parse.y"
{ yyval.v.number = AFI_IPv6; }
break;
case 89:
#line 943 "parse.y"
{ yyval.v.number = 1; }
break;
case 90:
#line 944 "parse.y"
{ yyval.v.number = 0; }
break;
case 91:
#line 947 "parse.y"
{
			bzero(&yyval.v.encspec, sizeof(yyval.v.encspec));
		}
break;
case 92:
#line 950 "parse.y"
{
			bzero(&yyval.v.encspec, sizeof(yyval.v.encspec));
			if (!strcmp(yyvsp[-1].v.string, "3des") || !strcmp(yyvsp[-1].v.string, "3des-cbc")) {
				yyval.v.encspec.enc_alg = SADB_EALG_3DESCBC;
				yyval.v.encspec.enc_key_len = 21; /* XXX verify */
			} else if (!strcmp(yyvsp[-1].v.string, "aes") ||
			    !strcmp(yyvsp[-1].v.string, "aes-128-cbc")) {
				yyval.v.encspec.enc_alg = SADB_X_EALG_AES;
				yyval.v.encspec.enc_key_len = 16;
			} else {
				yyerror("unknown enc algorithm \"%s\"", yyvsp[-1].v.string);
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);

			if (strlen(yyvsp[0].v.string) / 2 != yyval.v.encspec.enc_key_len) {
				yyerror("enc key length wrong: should be %u "
				    "bytes, is %u bytes",
				    yyval.v.encspec.enc_key_len * 2, strlen(yyvsp[0].v.string));
				free(yyvsp[0].v.string);
				YYERROR;
			}

			if (str2key(yyvsp[0].v.string, yyval.v.encspec.enc_key, sizeof(yyval.v.encspec.enc_key)) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 93:
#line 984 "parse.y"
{
			struct filter_rule	 r;
			struct filter_prefix_l	*l;

			for (l = yyvsp[-1].v.filter_match.prefix_l; l != NULL; l = l->next)
				if (l->p.addr.af && l->p.addr.af != AF_INET) {
					yyerror("king bula sez: AF_INET only");
					YYERROR;
				}

			bzero(&r, sizeof(r));
			r.action = yyvsp[-5].v.u8;
			r.quick = yyvsp[-4].v.u8;
			r.dir = yyvsp[-3].v.u8;

			if (expand_rule(&r, yyvsp[-2].v.filter_peers, &yyvsp[-1].v.filter_match, yyvsp[0].v.filter_set_head) == -1)
				YYERROR;
		}
break;
case 94:
#line 1004 "parse.y"
{ yyval.v.u8 = ACTION_ALLOW; }
break;
case 95:
#line 1005 "parse.y"
{ yyval.v.u8 = ACTION_DENY; }
break;
case 96:
#line 1006 "parse.y"
{ yyval.v.u8 = ACTION_NONE; }
break;
case 97:
#line 1009 "parse.y"
{ yyval.v.u8 = 0; }
break;
case 98:
#line 1010 "parse.y"
{ yyval.v.u8 = 1; }
break;
case 99:
#line 1013 "parse.y"
{ yyval.v.u8 = DIR_IN; }
break;
case 100:
#line 1014 "parse.y"
{ yyval.v.u8 = DIR_OUT; }
break;
case 102:
#line 1018 "parse.y"
{ yyval.v.filter_peers = yyvsp[-1].v.filter_peers; }
break;
case 103:
#line 1021 "parse.y"
{ yyval.v.filter_peers = yyvsp[0].v.filter_peers; }
break;
case 104:
#line 1022 "parse.y"
{
			yyvsp[0].v.filter_peers->next = yyvsp[-2].v.filter_peers;
			yyval.v.filter_peers = yyvsp[0].v.filter_peers;
		}
break;
case 105:
#line 1028 "parse.y"
{
			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.peerid = yyval.v.filter_peers->p.groupid = 0;
			yyval.v.filter_peers->next = NULL;
		}
break;
case 106:
#line 1035 "parse.y"
{
			struct peer *p;

			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.groupid = yyval.v.filter_peers->p.peerid = 0;
			yyval.v.filter_peers->next = NULL;
			for (p = peer_l; p != NULL; p = p->next)
				if (!memcmp(&p->conf.remote_addr,
				    &yyvsp[0].v.addr, sizeof(p->conf.remote_addr))) {
					yyval.v.filter_peers->p.peerid = p->conf.id;
					break;
				}
			if (yyval.v.filter_peers->p.peerid == 0) {
				yyerror("no such peer: %s", log_addr(&yyvsp[0].v.addr));
				free(yyval.v.filter_peers);
				YYERROR;
			}
		}
break;
case 107:
#line 1055 "parse.y"
{
			struct peer *p;

			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.peerid = 0;
			yyval.v.filter_peers->next = NULL;
			for (p = peer_l; p != NULL; p = p->next)
				if (!strcmp(p->conf.group, yyvsp[0].v.string)) {
					yyval.v.filter_peers->p.groupid = p->conf.groupid;
					break;
				}
			if (yyval.v.filter_peers->p.groupid == 0) {
				yyerror("no such group: \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				free(yyval.v.filter_peers);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 108:
#line 1078 "parse.y"
{ yyval.v.filter_prefix = yyvsp[0].v.filter_prefix; }
break;
case 109:
#line 1079 "parse.y"
{ yyval.v.filter_prefix = yyvsp[-1].v.filter_prefix; }
break;
case 111:
#line 1083 "parse.y"
{ yyval.v.filter_prefix = yyvsp[-1].v.filter_prefix; }
break;
case 112:
#line 1085 "parse.y"
{
			struct filter_prefix_l	*p;

			/* merge, both can be lists */
			for (p = yyvsp[-2].v.filter_prefix; p != NULL && p->next != NULL; p = p->next)
				;	/* nothing */
			if (p != NULL)
				p->next = yyvsp[0].v.filter_prefix;
			yyval.v.filter_prefix = yyvsp[-2].v.filter_prefix;
		}
break;
case 113:
#line 1097 "parse.y"
{ yyval.v.filter_prefix = yyvsp[0].v.filter_prefix; }
break;
case 114:
#line 1098 "parse.y"
{
			yyvsp[0].v.filter_prefix->next = yyvsp[-2].v.filter_prefix;
			yyval.v.filter_prefix = yyvsp[0].v.filter_prefix;
		}
break;
case 115:
#line 1104 "parse.y"
{
			if ((yyval.v.filter_prefix = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			memcpy(&yyval.v.filter_prefix->p.addr, &yyvsp[0].v.prefix.prefix,
			    sizeof(yyval.v.filter_prefix->p.addr));
			yyval.v.filter_prefix->p.len = yyvsp[0].v.prefix.len;
			yyval.v.filter_prefix->next = NULL;
		}
break;
case 117:
#line 1116 "parse.y"
{ yyval.v.filter_as = yyvsp[-1].v.filter_as; }
break;
case 119:
#line 1120 "parse.y"
{
			struct filter_as_l	*a;

			/* merge, both can be lists */
			for (a = yyvsp[-2].v.filter_as; a != NULL && a->next != NULL; a = a->next)
				;	/* nothing */
			if (a != NULL)
				a->next = yyvsp[0].v.filter_as;
			yyval.v.filter_as = yyvsp[-2].v.filter_as;
		}
break;
case 120:
#line 1132 "parse.y"
{
			yyval.v.filter_as = yyvsp[0].v.filter_as;
			yyval.v.filter_as->a.type = yyvsp[-1].v.u8;
		}
break;
case 121:
#line 1136 "parse.y"
{
			struct filter_as_l	*a;

			yyval.v.filter_as = yyvsp[-1].v.filter_as;
			for (a = yyval.v.filter_as; a != NULL; a = a->next)
				a->a.type = yyvsp[-3].v.u8;
		}
break;
case 123:
#line 1146 "parse.y"
{ yyval.v.filter_as = yyvsp[-1].v.filter_as; }
break;
case 124:
#line 1148 "parse.y"
{
			struct filter_as_l	*a;

			/* merge, both can be lists */
			for (a = yyvsp[-2].v.filter_as; a != NULL && a->next != NULL; a = a->next)
				;	/* nothing */
			if (a != NULL)
				a->next = yyvsp[0].v.filter_as;
			yyval.v.filter_as = yyvsp[-2].v.filter_as;
		}
break;
case 126:
#line 1161 "parse.y"
{
			yyvsp[0].v.filter_as->next = yyvsp[-2].v.filter_as;
			yyval.v.filter_as = yyvsp[0].v.filter_as;
		}
break;
case 127:
#line 1167 "parse.y"
{
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_as->a.as = yyvsp[0].v.number;
		}
break;
case 128:
#line 1175 "parse.y"
{ bzero(&yyval.v.filter_match, sizeof(yyval.v.filter_match)); }
break;
case 129:
#line 1176 "parse.y"
{ bzero(&fmopts, sizeof(fmopts)); }
break;
case 130:
#line 1177 "parse.y"
{
			memcpy(&yyval.v.filter_match, &fmopts, sizeof(yyval.v.filter_match));
		}
break;
case 133:
#line 1186 "parse.y"
{
			if (fmopts.prefix_l != NULL) {
				yyerror("\"prefix\" already specified");
				YYERROR;
			}
			fmopts.prefix_l = yyvsp[0].v.filter_prefix;
		}
break;
case 134:
#line 1193 "parse.y"
{
			if (fmopts.m.prefixlen.af) {
				yyerror("\"prefixlen\" already specified");
				YYERROR;
			}
			memcpy(&fmopts.m.prefixlen, &yyvsp[0].v.prefixlen,
			    sizeof(fmopts.m.prefixlen));
			fmopts.m.prefixlen.af = AF_INET;
		}
break;
case 135:
#line 1202 "parse.y"
{
			if (fmopts.as_l != NULL) {
				yyerror("AS filters already specified");
				YYERROR;
			}
			fmopts.as_l = yyvsp[0].v.filter_as;
		}
break;
case 136:
#line 1209 "parse.y"
{
			if (fmopts.m.community.as) {
				yyerror("\"community\" already specified");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (parsecommunity(yyvsp[0].v.string, &fmopts.m.community.as,
			    &fmopts.m.community.type) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 137:
#line 1224 "parse.y"
{
			bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen));
			if (yyvsp[0].v.number > 128) {
				yyerror("prefixlen must be < 128");
				YYERROR;
			}
			yyval.v.prefixlen.op = yyvsp[-1].v.u8;
			yyval.v.prefixlen.len_min = yyvsp[0].v.number;
		}
break;
case 138:
#line 1233 "parse.y"
{
			bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen));
			if (yyvsp[-2].v.number > 128 || yyvsp[0].v.number > 128) {
				yyerror("prefixlen must be < 128");
				YYERROR;
			}
			if (yyvsp[-2].v.number >= yyvsp[0].v.number) {
				yyerror("start prefixlen is bigger that end");
				YYERROR;
			}
			yyval.v.prefixlen.op = yyvsp[-1].v.u8;
			yyval.v.prefixlen.len_min = yyvsp[-2].v.number;
			yyval.v.prefixlen.len_max = yyvsp[0].v.number;
		}
break;
case 139:
#line 1249 "parse.y"
{ yyval.v.u8 = AS_ALL; }
break;
case 140:
#line 1250 "parse.y"
{ yyval.v.u8 = AS_SOURCE; }
break;
case 141:
#line 1251 "parse.y"
{ yyval.v.u8 = AS_TRANSIT; }
break;
case 142:
#line 1254 "parse.y"
{ yyval.v.filter_set_head = NULL; }
break;
case 143:
#line 1255 "parse.y"
{
			if ((yyval.v.filter_set_head = calloc(1, sizeof(struct filter_set_head))) ==
			    NULL)
				fatal(NULL);
			TAILQ_INIT(yyval.v.filter_set_head);
			TAILQ_INSERT_TAIL(yyval.v.filter_set_head, yyvsp[0].v.filter_set, entry);
		}
break;
case 144:
#line 1262 "parse.y"
{ yyval.v.filter_set_head = yyvsp[-2].v.filter_set_head; }
break;
case 145:
#line 1265 "parse.y"
{
			yyval.v.filter_set_head = yyvsp[-2].v.filter_set_head;
			if (merge_filterset(yyval.v.filter_set_head, yyvsp[0].v.filter_set) == 1)
				YYERROR;
		}
break;
case 146:
#line 1270 "parse.y"
{
			if ((yyval.v.filter_set_head = calloc(1, sizeof(struct filter_set_head))) ==
			    NULL)
				fatal(NULL);
			TAILQ_INIT(yyval.v.filter_set_head);
			TAILQ_INSERT_TAIL(yyval.v.filter_set_head, yyvsp[0].v.filter_set, entry);
		}
break;
case 147:
#line 1279 "parse.y"
{ yyval.v.u8 = 0; }
break;
case 148:
#line 1280 "parse.y"
{ yyval.v.u8 = 1; }
break;
case 149:
#line 1283 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_LOCALPREF;
			yyval.v.filter_set->action.metric = yyvsp[0].v.number;
		}
break;
case 150:
#line 1289 "parse.y"
{
			if (yyvsp[0].v.number > INT_MAX) {
				yyerror("localpref to big: max %u", INT_MAX);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_LOCALPREF;
			yyval.v.filter_set->action.relative = yyvsp[0].v.number;
		}
break;
case 151:
#line 1299 "parse.y"
{
			if (yyvsp[0].v.number > INT_MAX) {
				yyerror("localpref to small: min -%u", INT_MAX);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_LOCALPREF;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 152:
#line 1309 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_MED;
			yyval.v.filter_set->action.metric = yyvsp[0].v.number;
		}
break;
case 153:
#line 1315 "parse.y"
{
			if (yyvsp[0].v.number > INT_MAX) {
				yyerror("metric to big: max %u", INT_MAX);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.relative = yyvsp[0].v.number;
		}
break;
case 154:
#line 1325 "parse.y"
{
			if (yyvsp[0].v.number > INT_MAX) {
				yyerror("metric to small: min -%u", INT_MAX);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 155:
#line 1335 "parse.y"
{	/* alias for MED */
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_MED;
			yyval.v.filter_set->action.metric = yyvsp[0].v.number;
		}
break;
case 156:
#line 1341 "parse.y"
{
			if (yyvsp[0].v.number > INT_MAX) {
				yyerror("metric to big: max %u", INT_MAX);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.metric = yyvsp[0].v.number;
		}
break;
case 157:
#line 1351 "parse.y"
{
			if (yyvsp[0].v.number > INT_MAX) {
				yyerror("metric to small: min -%u", INT_MAX);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 158:
#line 1361 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_WEIGHT;
			yyval.v.filter_set->action.metric = yyvsp[0].v.number;
		}
break;
case 159:
#line 1367 "parse.y"
{
			if (yyvsp[0].v.number > INT_MAX) {
				yyerror("weight to big: max %u", INT_MAX);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_WEIGHT;
			yyval.v.filter_set->action.relative = yyvsp[0].v.number;
		}
break;
case 160:
#line 1377 "parse.y"
{
			if (yyvsp[0].v.number > INT_MAX) {
				yyerror("weight to small: min -%u", INT_MAX);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_WEIGHT;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 161:
#line 1387 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP;
			memcpy(&yyval.v.filter_set->action.nexthop, &yyvsp[0].v.addr,
			    sizeof(yyval.v.filter_set->action.nexthop));
		}
break;
case 162:
#line 1394 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_BLACKHOLE;
		}
break;
case 163:
#line 1399 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_REJECT;
		}
break;
case 164:
#line 1404 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_NOMODIFY;
		}
break;
case 165:
#line 1409 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_PREPEND_SELF;
			if (yyvsp[0].v.number > 128) {
				yyerror("too many prepends");
				YYERROR;
			}
			yyval.v.filter_set->action.prepend = yyvsp[0].v.number;
		}
break;
case 166:
#line 1419 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_PREPEND_PEER;
			if (yyvsp[0].v.number > 128) {
				yyerror("too many prepends");
				YYERROR;
			}
			yyval.v.filter_set->action.prepend = yyvsp[0].v.number;
		}
break;
case 167:
#line 1429 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_PFTABLE;
			if (!(conf->opts & BGPD_OPT_NOACTION) &&
			    pftable_exists(yyvsp[0].v.string) != 0) {
				yyerror("pftable name does not exist");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (strlcpy(yyval.v.filter_set->action.pftable, yyvsp[0].v.string,
			    sizeof(yyval.v.filter_set->action.pftable)) >=
			    sizeof(yyval.v.filter_set->action.pftable)) {
				yyerror("pftable name too long");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (pftable_add(yyvsp[0].v.string) != 0) {
				yyerror("Couldn't register table");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 168:
#line 1453 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_RTLABEL;
			if (strlcpy(yyval.v.filter_set->action.rtlabel, yyvsp[0].v.string,
			    sizeof(yyval.v.filter_set->action.rtlabel)) >=
			    sizeof(yyval.v.filter_set->action.rtlabel)) {
				yyerror("rtlabel name too long");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 169:
#line 1466 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[-1].v.u8)
				yyval.v.filter_set->type = ACTION_DEL_COMMUNITY;
			else
				yyval.v.filter_set->type = ACTION_SET_COMMUNITY;

			if (parsecommunity(yyvsp[0].v.string, &yyval.v.filter_set->action.community.as,
			    &yyval.v.filter_set->action.community.type) == -1) {
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			/* Don't allow setting of any match */
			if ((!yyvsp[-1].v.u8) && (yyval.v.filter_set->action.community.as == COMMUNITY_ANY ||
			    yyval.v.filter_set->action.community.type == COMMUNITY_ANY)) {
				yyerror("'*' is not allowed in set community");
				free(yyval.v.filter_set);
				YYERROR;
			}
			/* Don't allow setting of unknown well-known types */
			if (yyval.v.filter_set->action.community.as == COMMUNITY_WELLKNOWN) {
				switch (yyval.v.filter_set->action.community.type) {
				case COMMUNITY_NO_EXPORT:
				case COMMUNITY_NO_ADVERTISE:
				case COMMUNITY_NO_EXPSUBCONFED:
				case COMMUNITY_NO_PEER:
					/* valid */
					break;
				default:
					/* unknown */
					yyerror("Invalid well-known community");
					free(yyval.v.filter_set);
					YYERROR;
					break;
				}
			}
		}
break;
case 172:
#line 1512 "parse.y"
{ yyval.v.u8 = OP_EQ; }
break;
case 173:
#line 1513 "parse.y"
{ yyval.v.u8 = OP_NE; }
break;
case 174:
#line 1514 "parse.y"
{ yyval.v.u8 = OP_LE; }
break;
case 175:
#line 1515 "parse.y"
{ yyval.v.u8 = OP_LT; }
break;
case 176:
#line 1516 "parse.y"
{ yyval.v.u8 = OP_GE; }
break;
case 177:
#line 1517 "parse.y"
{ yyval.v.u8 = OP_GT; }
break;
case 178:
#line 1520 "parse.y"
{ yyval.v.u8 = OP_RANGE; }
break;
case 179:
#line 1521 "parse.y"
{ yyval.v.u8 = OP_XRANGE; }
break;
#line 3579 "parse.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
