--- ./bgpctl/parser.c.dist	Tue Jan  9 16:59:40 2007
+++ ./bgpctl/parser.c	Mon Jan  8 10:52:08 2007
@@ -279,7 +279,7 @@
 int			 parse_addr(const char *, struct bgpd_addr *);
 int			 parse_prefix(const char *, struct bgpd_addr *,
 			     u_int8_t *);
-int			 parse_asnum(const char *, u_int16_t *);
+int			 parse_asnum(const char *, u_int32_t *);
 int			 parse_number(const char *, struct parse_result *,
 			     enum token_type);
 int			 getcommunity(const char *);
@@ -611,9 +611,10 @@
 }
 
 int
-parse_asnum(const char *word, u_int16_t *asnum)
+parse_asnum(const char *word, u_int32_t *asnum)
 {
 	u_long	 ulval;
+        u_long   ulval2;
 	char	*ep;
 
 	if (word == NULL)
@@ -621,13 +622,24 @@
 
 	errno = 0;
 	ulval = strtoul(word, &ep, 0);
+        if (ep == '.') {
+	        ++ep;
+                ulval2 = strtoul(ep,&ep,0);
+                if (ulval > USHRT_MAX) 
+		        return(0);
+                if (ulval2 > USHRT_MAX) 
+		        return(0);
+                ulval = (ulval << 16) + ulval2;
+        }
 	if (word[0] == '\0' || *ep != '\0')
 		return (0);
+        /*
 	if (errno == ERANGE && ulval == ULONG_MAX)
 		return (0);
-	if (ulval > USHRT_MAX)
+	*/
+	if (ulval > UINT_MAX)
 		return (0);
-	*asnum = (u_int16_t)ulval;
+	*asnum = (u_int32_t)ulval;
 	return (1);
 }
 
