--- ./bgpd/rde_update.c.dist	Wed Jan 10 09:22:24 2007
+++ ./bgpd/rde_update.c	Wed Jan 10 09:19:08 2007
@@ -15,6 +15,10 @@
  * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  */
+
+/* +4-Byte AS:   modifications for 4 Byte AS Number Support - 
+                 Geoff Huston, January 2007 */
+
 #include <sys/types.h>
 #include <sys/queue.h>
 #include <sys/hash.h>
@@ -284,8 +288,10 @@
 		break;
 	}
 
+        /* +4-Byte AS:   add as size param to loopfree call */
+
 	if (peer->conf.ebgp && !aspath_loopfree(p->aspath->aspath,
-	    peer->conf.remote_as)) {
+						peer->conf.remote_as,4)) {
 		/*
 		 * Do not send routes back to sender which would
 		 * cause an aspath loop.
@@ -466,7 +472,10 @@
 		return;
 
 	asp = path_get();
-	asp->aspath = aspath_get(NULL, 0);
+
+        /* +4-Byte AS:   add as size param to aspath_get call */
+
+	asp->aspath = aspath_get(NULL, 0, 4);
 	asp->origin = ORIGIN_IGP;
 	/* the other default values are OK, nexthop is once again NULL */
 
@@ -619,6 +628,8 @@
     struct rde_aspath *a, sa_family_t af)
 {
 	struct aspath	*path;
+        /* +4-Byte AS:   add oasp var */
+        struct aspath   *oasp;
 	struct attr	*oa;
 	u_int32_t	 tmp32;
 	in_addr_t	 nexthop;
@@ -639,7 +650,23 @@
 	else
 		path = aspath_prepend(a->aspath, rde_local_as(), 1);
 
+        /* +4-Byte AS:  if this is a 2 byte peer then the as path will been to be translated
+                        into a 2byte version and this 4byte path written out as ATTR_NEW_ASPATH */
+        if (!(peer->capa_received.as_4bytes)) {
+                if ((oasp = aspath_convert(path)) == NULL) 
+                        return(-1) ;
+  
+
 	if ((r = attr_write(up_attr_buf + wlen, len, ATTR_WELL_KNOWN,
+                                ATTR_ASPATH, oasp->data, oasp->len)) == -1)
+                        return (-1);
+                aspath_put(oasp);
+                wlen += r; len -= r;
+                if ((r = attr_write(up_attr_buf + wlen, len, (ATTR_TRANSITIVE | ATTR_OPTIONAL),
+                                ATTR_NEW_ASPATH, path->data, path->len)) == -1)
+                        return (-1);
+         }
+         else if ((r = attr_write(up_attr_buf + wlen, len, ATTR_WELL_KNOWN,
 	    ATTR_ASPATH, path->data, path->len)) == -1)
 		return (-1);
 	aspath_put(path);
