--- ./bgpd/rde.h.dist	Wed Jan 10 09:22:24 2007
+++ ./bgpd/rde.h	Wed Jan 10 09:19:08 2007
@@ -16,6 +16,11 @@
  * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  */
+
+
+/* +4-Byte AS:   modifications for 4 Byte AS Number Support - 
+                 Geoff Huston, January 2007 */
+
 #ifndef __RDE_H__
 #define __RDE_H__
 
@@ -87,6 +92,7 @@
 	u_char			data[1]; /* placeholder for actual data */
 };
 
+/* +4-Byte AS:   add new_aspath and new_aggregator type codes */
 enum attrtypes {
 	ATTR_UNDEF,
 	ATTR_ORIGIN,
@@ -100,7 +106,9 @@
 	ATTR_ORIGINATOR_ID,
 	ATTR_CLUSTER_LIST,
 	ATTR_MP_REACH_NLRI=14,
-	ATTR_MP_UNREACH_NLRI=15
+	ATTR_MP_UNREACH_NLRI=15,
+        ATTR_NEW_ASPATH=ATTRIBUTE_NEW_AS_PATH,
+        ATTR_NEW_AGGREGATOR=ATTRIBUTE_NEW_AGGREGATOR
 };
 
 /* attribute flags. 4 low order bits reserved */
@@ -257,7 +265,9 @@
 void		 rde_send_pftable_commit(void);
 
 void		 rde_generate_updates(struct prefix *, struct prefix *);
-u_int16_t	 rde_local_as(void);
+
+/* +4-Byte AS:   AS is u_int32_t type */
+u_int32_t	 rde_local_as(void);
 int		 rde_noevaluate(void);
 int		 rde_decisionflags(void);
 
@@ -273,22 +283,37 @@
 int		 attr_compare(struct rde_aspath *, struct rde_aspath *);
 void		 attr_freeall(struct rde_aspath *);
 
-int		 aspath_verify(void *, u_int16_t);
+/* +4-Byte AS:   need access to put and free calls */
+void             attr_put(struct attr *) ;
+void             attr_free(struct rde_aspath *, struct attr *);
+/* +4-Byte AS:   add as size parameter */
+int              aspath_verify(void *, u_int16_t, u_int8_t);
+
 #define		 AS_ERR_LEN	-1
 #define		 AS_ERR_TYPE	-2
 #define		 AS_ERR_BAD	-3
 void		 aspath_init(u_int32_t);
 void		 aspath_shutdown(void);
-struct aspath	*aspath_get(void *, u_int16_t);
+/* +4-Byte AS:   add as size parameter */
+struct aspath	*aspath_get(void *, u_int16_t, int);
 void		 aspath_put(struct aspath *);
 u_char		*aspath_dump(struct aspath *);
 u_int16_t	 aspath_length(struct aspath *);
-u_int16_t	 aspath_count(const void *, u_int16_t);
-u_int16_t	 aspath_neighbor(struct aspath *);
-int		 aspath_loopfree(struct aspath *, u_int16_t);
+/* +4-Byte AS:   add as size parameter */
+u_int16_t	 aspath_count(const void *, u_int16_t, int);
+/* +4-Byte AS:   add as size parameter */
+u_int16_t	 aspath_neighbor(struct aspath *, int);
+/* +4-Byte AS:   add as size parameter */
+int		 aspath_loopfree(struct aspath *, u_int16_t, int);
 int		 aspath_compare(struct aspath *, struct aspath *);
-struct aspath	*aspath_prepend(struct aspath *, u_int16_t, int);
-int		 aspath_match(struct aspath *, enum as_spec, u_int16_t);
+/* +4-Byte AS:   AS is u_int32_t type */
+struct aspath	*aspath_prepend(struct aspath *, u_int32_t, int);
+int		 aspath_match(struct aspath *, enum as_spec, u_int32_t, int);
+/* +4-Byte AS:   AS path attribute conversion routintes */
+struct aspath   *aspath_translate(struct aspath *, u_int8_t *, u_int16_t);
+u_char          *aspath_inflate(void *, u_int16_t, u_int16_t *);
+struct aspath   *aspath_convert(struct aspath *);
+
 int		 community_match(void *, u_int16_t, int, int);
 int		 community_set(struct rde_aspath *, int, int);
 void		 community_delete(struct rde_aspath *, int, int);
@@ -377,6 +402,9 @@
 		     struct rde_peer *, enum directions);
 
 /* util.c */
-u_int16_t	 aspath_extract(const void *, int);
+/* +4-Byte AS:   add as size parameter and return a 4 byte AS value */
+u_int32_t	 aspath_extract(const void *, int, int);
+/* +4-Byte AS:   general AS extraction routine */
+u_int32_t        as_extract(const void *, int);
 
 #endif /* __RDE_H__ */
