--- ./bgpd/rde.c.dist	Wed Jan 10 09:22:24 2007
+++ ./bgpd/rde.c	Wed Jan 10 21:43:07 2007
@@ -16,6 +16,9 @@
  * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  */
 
+/* +4-Byte AS:   modifications for 4 Byte AS Number Support - 
+                 Geoff Huston, January 2007 */
+
 #include <sys/types.h>
 #include <sys/socket.h>
 
@@ -626,6 +629,13 @@
 {
 	struct rde_peer		*peer;
 	struct rde_aspath	*asp = NULL, *fasp;
+
+	/* +4-Byte AS:   additional variables for translation of as path */
+        struct attr             *a, *b;
+        struct attr              tmp;
+        struct aspath           *new_aspath;
+        u_int32_t                aggregator_as;
+        
 	u_char			*p, *mpp = NULL;
 	int			 pos = 0;
 	u_int16_t		 afi, len, mplen;
@@ -679,6 +689,55 @@
 			len -= pos;
 		}
 
+		/* +4-Byte AS:   perform a NEW_AGGREGATOR -> AGGREGATOR substitution */
+                /* perform an AGGREGATOR substitution */
+                /* first check that NEW_AGGREGATOR attribute was present */
+                if ((a = attr_optget(asp, ATTR_NEW_AGGREGATOR)) != NULL) {
+                        /* second, check that an AGGREGATOR attribute was present */
+                        if ((b = attr_optget(asp, ATTR_AGGREGATOR)) != NULL) {
+                                /* then check that we are on a 2 byte to 4 byte boundary */
+                                /* and the AGGREGATOR is AS_TRANS */
+                                if (!(peer->capa_received.as_4bytes)) {
+                                        aggregator_as = as_extract(b->data,4) ;
+                                        if (aggregator_as == AS_TRANS) {
+  					        /* Then copy over NEW value */
+                                                memcpy(b->data,a->data,4) ;
+                                               /* now re-hash the aggregator attribute by 
+                                                  releasing it and re-adding it*/
+                                               tmp.flags = b->flags ;
+                                               tmp.type = b->flags ;
+                                               tmp.len = b->len ;
+                                               tmp.data = malloc(tmp.len) ;
+                                               memcpy(tmp.data,b->data,tmp.len) ;
+                                               attr_free(asp,b) ;
+                                               attr_optadd(asp,tmp.flags,tmp.type,tmp.data,tmp.len) ;
+                                               free(tmp.data) ;
+                                       }
+                                }
+                        }
+                        /* now remove the NEW_AGGREGATOR attribute */
+                        attr_free(asp,a) ;
+                }
+ 
+		/* +4-Byte AS:   perform a NEW_ASPATH -> ASPATH substitution */
+                /* attempt a PATH substitution */
+                /* first check that NEW_PATH attribute was present */
+                if ((a = attr_optget(asp, ATTR_NEW_ASPATH)) != NULL) {
+                        /* then check that we are on a 2 byte to 4 byte boundary */
+                        if (!(peer->capa_received.as_4bytes)) {
+                                if ((new_aspath = aspath_translate(asp->aspath,a->data,a->len)) == NULL) {
+                                        rde_update_err(peer, ERR_UPDATE, ERR_UPD_NEWASPATH, NULL, 0);
+                                        path_put(asp);
+                                        return (-1);
+                                }
+                                aspath_put(asp->aspath) ;
+                                asp->aspath = new_aspath;
+                        }
+                        /* now remove the NEW_AS_PATH attribute */
+                        attr_free(asp,a) ;
+                }
+   
+
 		/* check for missing but necessary attributes */
 		if ((subtype = rde_attr_missing(asp, peer->conf.ebgp,
 		    nlri_len))) {
@@ -692,7 +751,8 @@
 		if (asp->flags & F_ATTR_ASPATH &&
 		    peer->conf.enforce_as == ENFORCE_AS_ON)
 			if (peer->conf.remote_as !=
-			    aspath_neighbor(asp->aspath)) {
+		            /* +4-Byte AS:   aspath neighbor using 4 byte as path */
+			    aspath_neighbor(asp->aspath,4)) {
 				rde_update_err(peer, ERR_UPDATE, ERR_UPD_ASPATH,
 				    NULL, 0);
 				path_put(asp);
@@ -820,7 +880,9 @@
 	p += 2 + attrpath_len;
 
 	/* aspath needs to be loop free nota bene this is not a hard error */
-	if (peer->conf.ebgp && !aspath_loopfree(asp->aspath, conf->as)) {
+
+        /* +4-Byte AS:   aspath loopfree using 4 byte as path */
+	if (peer->conf.ebgp && !aspath_loopfree(asp->aspath, conf->as, 4)) {
 		path_put(asp);
 		return (0);
 	}
@@ -1024,6 +1086,9 @@
 	u_int8_t	 flags;
 	u_int8_t	 type;
 	u_int8_t	 tmp8;
+	/* +4-Byte AS:   additional local variables */
+        u_char          *new_p;
+        u_int16_t        new_attr_len;
 
 	if (len < 3) {
 bad_len:
@@ -1078,7 +1143,9 @@
 	case ATTR_ASPATH:
 		if (!CHECK_FLAGS(flags, ATTR_WELL_KNOWN, 0))
 			goto bad_flags;
-		if (aspath_verify(p, attr_len) != 0) {
+
+  	        /* +4-Byte AS:   pass 4 byte capability to the verify function */
+		if (aspath_verify(p, attr_len, peer->capa_received.as_4bytes) < 0) {
 			rde_update_err(peer, ERR_UPDATE, ERR_UPD_ASPATH,
 			    NULL, 0);
 			return (-1);
@@ -1086,9 +1153,37 @@
 		if (a->flags & F_ATTR_ASPATH)
 			goto bad_list;
 		a->flags |= F_ATTR_ASPATH;
-		a->aspath = aspath_get(p, attr_len);
+  	        /* +4-Byte AS:   inflate the received AS path to 4 byte ASs */
+                new_p = p ;
+                new_attr_len = attr_len ;
+                if (!(peer->capa_received.as_4bytes)) {
+                        if (!(new_p = aspath_inflate(p,attr_len,&new_attr_len))) 
+                        return(-1) ;
+                }     
+                a->aspath = aspath_get(new_p, new_attr_len,4);
+                if (!(peer->capa_received.as_4bytes)) {
+                        free(new_p) ;
+                }     
 		plen += attr_len;
 		break;
+  	        /* +4-Byte AS:   process the NEW AS PATH attribute - just store it at this stage */
+        case ATTR_NEW_ASPATH:
+                /* should only receive this attr from 2 byte as (old) bgp peers */
+                if (peer->capa_received.as_4bytes)
+                        goto bad_flags ; 
+                if (attr_len <= 4)
+                        goto bad_len; 
+                /* flag setting is optional (0x80) and transitive (0x40) */
+                if (!(flags & (ATTR_OPTIONAL | ATTR_TRANSITIVE)))
+                        goto bad_flags; 
+                if (aspath_verify(p, attr_len, 1) < 0) {
+                        rde_update_err(peer, ERR_UPDATE, ERR_UPD_NEWASPATH,
+                            NULL, 0);
+                        return (-1);
+                }
+                /* store this attribute and perform path sustitution at the end of the
+                   attribute parse block */
+                goto optattr;
 	case ATTR_NEXTHOP:
 		if (attr_len != 4)
 			goto bad_len;
@@ -1149,10 +1244,37 @@
 			goto bad_flags;
 		goto optattr;
 	case ATTR_AGGREGATOR:
-		if (attr_len != 6)
+  	        /* +4-Byte AS:   change the aggregator attribute processing - note the changed length */
+                if ((peer->capa_received.as_4bytes) && (attr_len != 8))
+                        goto bad_len;
+                if ((!(peer->capa_received.as_4bytes)) && (attr_len != 6))
 			goto bad_len;
 		if (!CHECK_FLAGS(flags, ATTR_OPTIONAL|ATTR_TRANSITIVE, 0))
 			goto bad_flags;
+                if (peer->capa_received.as_4bytes)
+                        goto optattr;
+		/* convert this is a 4 byte AS */
+                new_attr_len = attr_len + 2 ;
+                if ((new_p = malloc(new_attr_len)) == NULL)
+                        fatal("rde_attr_parse") ;
+                new_p[0] = 0; 
+                new_p[1] = 0 ;
+                memcpy(&new_p[2],p,6);
+                if (attr_optadd(a, flags, type, new_p, new_attr_len) == -1) {
+                        rde_update_err(peer, ERR_UPDATE, ERR_UPD_ATTRLIST,NULL, 0);
+                        return (-1);
+                }
+                free(new_p) ;
+                plen += attr_len;
+                break;
+        case ATTR_NEW_AGGREGATOR:
+                /* should only receive this attr from 2 byte as (old) bgp peers */
+                if (peer->capa_received.as_4bytes)
+                        goto bad_flags ;
+                if (attr_len != 8)
+                        goto bad_len;
+                if (!(flags & (ATTR_OPTIONAL | ATTR_TRANSITIVE)))
+                        goto bad_flags;
 		goto optattr;
 	case ATTR_COMMUNITIES:
 		if ((attr_len & 0x3) != 0)
@@ -1527,7 +1649,8 @@
 
 	for (i = 0; i <= pathtable.path_hashmask; i++) {
 		LIST_FOREACH(asp, &pathtable.path_hashtbl[i], path_l) {
-			if (!aspath_match(asp->aspath, a->type, a->as))
+		        /* +4-Byte AS:   add AS size */
+		        if (!aspath_match(asp->aspath, a->type, a->as, 4))
 				continue;
 			/* match found */
 			LIST_FOREACH(p, &asp->prefix_h, path_l)
@@ -1957,7 +2080,9 @@
 /*
  * generic helper function
  */
-u_int16_t
+		        
+/* +4-Byte AS:   AS is u_int32_t */
+u_int32_t
 rde_local_as(void)
 {
 	return (conf->as);
@@ -2261,7 +2386,8 @@
 	struct rde_peer		*p;
 
 	asp = path_get();
-	asp->aspath = aspath_get(NULL, 0);
+        /* +4-Byte AS:   get a 4-byte path struct */ 
+	asp->aspath = aspath_get(NULL, 0, 4);
 	asp->origin = ORIGIN_IGP;
 	asp->flags = F_ATTR_ORIGIN | F_ATTR_ASPATH |
 	    F_ATTR_LOCALPREF | F_PREFIX_ANNOUNCED;
