--- ./bgpd/printconf.c.dist	Wed Jan 10 09:22:24 2007
+++ ./bgpd/printconf.c	Wed Jan 10 09:19:08 2007
@@ -16,6 +16,9 @@
  * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  */
 
+/* +4-Byte AS:   modifications for 4 Byte AS Number Support - 
+                 Geoff Huston, January 2007 */
+
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
@@ -150,7 +153,8 @@
 	struct in_addr		 ina;
 	struct listen_addr	*la;
 
-	printf("AS %u\n", conf->as);
+	/* +4-Byte AS:   print AS number as x.y */
+	printf("AS %u.%u\n", ((conf->as >> 16) & 65535), (conf->as & 65535));
 	ina.s_addr = conf->bgpid;
 	printf("router-id %s\n", inet_ntoa(ina));
 	if (conf->holdtime)
@@ -236,8 +240,11 @@
 		printf("%sneighbor %s {\n", c, log_addr(&p->remote_addr));
 	if (p->descr[0])
 		printf("%s\tdescr \"%s\"\n", c, p->descr);
+
+	/* +4-Byte AS:   print AS number as x.y */
 	if (p->remote_as)
-		printf("%s\tremote-as %u\n", c, p->remote_as);
+  	        printf("%s\tremote-as %u.%u\n", c, 
+		    ((p->remote_as >> 16) & 65535), (p->remote_as & 65535));
 	if (p->distance > 1)
 		printf("%s\tmultihop %u\n", c, p->distance);
 	if (p->passive)
@@ -421,14 +428,23 @@
 	}
 
 	if (r->match.as.type) {
+	/* +4-Byte AS:   print AS number as x.y */
 		if (r->match.as.type == AS_ALL)
-			printf("AS %u ", r->match.as.as);
+                        printf("AS %u.%u ", 
+                            ((r->match.as.as >> 16) & 65535) ,
+                            (r->match.as.as & 65535));
 		else if (r->match.as.type == AS_SOURCE)
-			printf("source-as %u ", r->match.as.as);
+                        printf("source-as %u.%u ", 
+                            ((r->match.as.as >> 16) & 65535), 
+                            (r->match.as.as & 65535));
 		else if (r->match.as.type == AS_TRANSIT)
-			printf("transit-as %u ", r->match.as.as);
-		else
-			printf("unfluffy-as %u ", r->match.as.as);
+                        printf("transit-as %u.%u ", 
+                            ((r->match.as.as >> 16) & 65535), 
+                            (r->match.as.as & 65535));
+                else
+                        printf("unfluffy-as %u.%u ", 
+                            ((r->match.as.as >> 16) & 65535), 
+                            (r->match.as.as & 65535));
 	}
 
 	if (r->match.community.as != 0) {
