--- ./bgpctl/parser.c.dist	Wed Jan 10 09:22:25 2007
+++ ./bgpctl/parser.c	Wed Jan 10 09:19:50 2007
@@ -16,6 +16,9 @@
  * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  */
 
+/* +4-Byte AS:   modifications for 4 Byte AS Number Support - 
+                Geoff Huston, January 2007 */
+
 #include <sys/types.h>
 #include <sys/socket.h>
 
@@ -266,7 +269,9 @@
 int			 parse_addr(const char *, struct bgpd_addr *);
 int			 parse_prefix(const char *, struct bgpd_addr *,
 			     u_int8_t *);
-int			 parse_asnum(const char *, u_int16_t *);
+
+/* +4-Byte AS:   as numbers are u_int32_t */
+int			 parse_asnum(const char *, u_int32_t *);
 int			 parse_number(const char *, struct parse_result *,
 			     enum token_type);
 int			 getcommunity(const char *);
@@ -588,10 +593,14 @@
 	return (1);
 }
 
+/* +4-Byte AS:   as numbers are u_int32_t type */
 int
-parse_asnum(const char *word, u_int16_t *asnum)
+parse_asnum(const char *word, u_int32_t *asnum)
 {
 	u_long	 ulval;
+
+/* +4-Byte AS:   additional local var for second number field */
+        u_long   ulval2;
 	char	*ep;
 
 	if (word == NULL)
@@ -599,13 +608,26 @@
 
 	errno = 0;
 	ulval = strtoul(word, &ep, 0);
+
+/* +4-Byte AS:   parse for second digit field */
+        if (*ep == '.') {
+	        ++ep ;
+                ulval2 = strtoul(ep,&ep,0);
+                if (ulval > USHRT_MAX)
+		        return(0) ;
+                if (ulval2 > USHRT_MAX)
+		        return(0) ;
+                ulval = (ulval << 16) + ulval2;
+	}
+
 	if (word[0] == '\0' || *ep != '\0')
 		return (0);
 	if (errno == ERANGE && ulval == ULONG_MAX)
 		return (0);
-	if (ulval > USHRT_MAX)
+/* +4-Byte AS:   as numbers are now up to 32 bits in length */
+	if (ulval > UINT_MAX)
 		return (0);
-	*asnum = (u_int16_t)ulval;
+	*asnum = (u_int32_t)ulval;
 	return (1);
 }
 
