--- ./bgpd/parse.y.dist	Wed Jan 10 09:22:24 2007
+++ ./bgpd/parse.y	Wed Jan 10 09:19:08 2007
@@ -19,6 +19,9 @@
  * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  */
 
+/* +4-Byte AS:   modifications for 4 Byte AS Number Support - 
+                 Geoff Huston, January 2007 */
+
 %{
 #include <sys/types.h>
 #include <sys/socket.h>
@@ -165,7 +168,9 @@
 %token	IPSEC ESP AH SPI IKE
 %token	IPV4 IPV6
 %token	<v.string>		STRING
-%type	<v.number>		number asnumber optnumber yesno inout espah
+ /* +4-Byte AS:   allow an as number to be represented as a dotted couplet */
+%type   <v.number>              dnumber asnumber
+%type	<v.number>		number optnumber yesno inout espah
 %type	<v.number>		family
 %type	<v.string>		string
 %type	<v.addr>		address
@@ -207,12 +212,46 @@
 		}
 		;
 
-asnumber	: number			{
-			if ($1 > USHRT_MAX) {
-				yyerror("AS too big: max %u", USHRT_MAX);
+ /* +4-Byte AS:   allow an as number to be represented as a dotted couplet */
+dnumber         : STRING                        {
+                u_long       ulval, ulval2;
+                char *dot ;
+
+                if ((dot = strchr($1,'.')) != NULL) {
+                        *dot = '\0';
+                        ++dot ; 
+                        if (atoul(dot,&ulval2) == -1) {
+                                yyerror("\"%s\" is not a number", $1);
+                                free($1);
+                                YYERROR;
+                        }
+                        else if (atoul($1, &ulval) == -1) {
+                                yyerror("\"%s\" is not a number", $1);
+                                free($1);
+                                YYERROR;
+                        }
+                        else
+                                $$ = (ulval << 16) + ulval2 ;
+                }
+                else 
+                       if (atoul($1, &ulval) == -1) {
+                                yyerror("\"%s\" is not a number", $1);
+                                free($1);
+                                YYERROR;
+                       } 
+                       else
+                               $$ = ulval;
+                       free($1);
+                }
+                ;
+
+asnumber        : dnumber {
+                      if ($1 > ULONG_MAX) {
+                              yyerror("AS too big: max %u", ULONG_MAX);
 				YYERROR;
 			}
 		}
+                ;
 
 string		: string STRING				{
 			if (asprintf(&$$, "%s %s", $1, $2) == -1)
@@ -2114,6 +2153,8 @@
 	p->conf.capabilities.mp_v4 = SAFI_UNICAST;
 	p->conf.capabilities.mp_v6 = SAFI_NONE;
 	p->conf.capabilities.refresh = 1;
+ /* +4-Byte AS:   default is to announce 4 byte capability */
+        p->conf.capabilities.as_4bytes = 1;
 	p->conf.softreconfig_in = 1;
 	p->conf.softreconfig_out = 1;
 
