--- ./bgpd/bgpd.h.dist	Wed Jan 10 09:22:23 2007
+++ ./bgpd/bgpd.h	Wed Jan 10 09:19:09 2007
@@ -15,6 +15,10 @@
  * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  */
+
+/* +4-Byte AS:   modifications for 4 Byte AS Number Support - 
+                 Geoff Huston, January 2007 */
+
 #ifndef __BGPD_H__
 #define	__BGPD_H__
 
@@ -148,7 +152,8 @@
 	int					 log;
 	u_int32_t				 bgpid;
 	u_int32_t				 clusterid;
-	u_int16_t				 as;
+  /* +4-Byte AS:   as numbers a u_int32_t type */
+	u_int32_t				 as;
 	u_int16_t				 holdtime;
 	u_int16_t				 min_holdtime;
 };
@@ -206,6 +211,9 @@
 	u_int8_t	mp_v4;		/* multiprotocol extensions, RFC 2858 */
 	u_int8_t	mp_v6;
 	u_int8_t	refresh;	/* route refresh, RFC 2918 */
+        u_int8_t        as_4bytes;      /* +4-Byte AS:   1 = 4byte as capable */
+
+
 };
 
 struct peer_config {
@@ -222,7 +230,9 @@
 	enum announce_type	 announce_type;
 	enum enforce_as		 enforce_as;
 	enum reconf_action	 reconf_action;
-	u_int16_t		 remote_as;
+
+  /* +4-Byte AS:   as numbers are u_int32_t type */
+	u_int32_t		 remote_as;
 	u_int16_t		 holdtime;
 	u_int16_t		 min_holdtime;
 	u_int8_t		 template;
@@ -236,8 +246,14 @@
 	u_int8_t		 reflector_client;
 	u_int8_t		 softreconfig_in;
 	u_int8_t		 softreconfig_out;
+
+  /* +4-Byte AS:   peer's capability to support 4 byte as numbers */
+        u_int8_t                 as_4bytes;
 };
 
+  /* +4-Byte AS:   define transition 2 byte AS value */
+#define AS_TRANS        23456
+
 struct network_config {
 	struct bgpd_addr	prefix;
 	struct filter_set_head	attrset;
@@ -367,7 +383,10 @@
 	ERR_UPD_NEXTHOP,
 	ERR_UPD_OPTATTR,
 	ERR_UPD_NETWORK,
-	ERR_UPD_ASPATH
+	ERR_UPD_ASPATH,
+
+  /* +4-Byte AS:   new suberror types */
+	ERR_UPD_NEWASPATH
 };
 
 enum suberr_cease {
@@ -493,7 +512,9 @@
 
 struct filter_as {
 	enum as_spec	type;
-	u_int16_t	as;
+
+  /* +4-Byte AS:   AS number is u_int32_t type */
+	u_int32_t	as;
 };
 
 enum filter_actions {
@@ -541,6 +562,30 @@
 #define	COMMUNITY_NO_EXPSUBCONFED	0xff03
 #define	COMMUNITY_NO_PEER		0xff04	/* rfc3765 */
 
+  /* +4-Byte AS:   define attribute type codes */
+/* BGP Path Attributes */
+#define ATTRIBUTE_ORIGIN                            1
+#define ATTRIBUTE_AS_PATH                           2
+#define ATTRIBUTE_NEXT_HOP                          3
+#define ATTRIBUTE_MULTI_EXIT_DISC                   4
+#define ATTRIBUTE_LOCAL_PREF                        5
+#define ATTRIBUTE_ATOMIC_AGGREGATE                  6
+#define ATTRIBUTE_AGGREGATOR                        7
+#define ATTRIBUTE_COMMUNITY                         8
+#define ATTRIBUTE_ORIGINATOR_ID                     9
+#define ATTRIBUTE_CLUSTER_LIST                     10
+#define ATTRIBUTE_DPA                              11
+#define ATTRIBUTE_ADVERTISER                       12
+#define ATTRIBUTE_RCID_PATH_CLUSTER_ID             13
+#define ATTRIBUTE_MP_REACH_NLRI                    14
+#define ATTRIBUTE_MP_UNREACH_NLRI                  15
+#define ATTRIBUTE_EXTENDED_COMMUNITIES             16
+#define ATTRIBUTE_NEW_AS_PATH                      17
+#define ATTRIBUTE_NEW_AGGREGATOR                   18
+#define ATTRIBUTE_SSA                              19
+#define ATTRIBUTE_CONNECTOR                        20
+#define ATTRIBUTE_AS_PATHLIMIT                     21
+
 struct filter_prefix {
 	struct bgpd_addr	addr;
 	u_int8_t		len;
@@ -554,7 +599,9 @@
 };
 
 struct filter_community {
-	int			as;
+
+  /* +4-Byte AS:   AS number is u_int32_t type */
+	u_int32_t		as;
 	int			type;
 };
 
@@ -768,8 +815,10 @@
 const char	*log_addr(const struct bgpd_addr *);
 const char	*log_in6addr(const struct in6_addr *);
 const char *	 log_sockaddr(struct sockaddr *);
-int		 aspath_snprint(char *, size_t, void *, u_int16_t);
-int		 aspath_asprint(char **, void *, u_int16_t);
-size_t		 aspath_strlen(void *, u_int16_t);
+
+  /* +4-Byte AS:   add as size parameter to the print calls */
+int		 aspath_snprint(char *, size_t, void *, u_int16_t, int);
+int		 aspath_asprint(char **, void *, u_int16_t, int);
+size_t		 aspath_strlen(void *, u_int16_t, int);
 
 #endif /* __BGPD_H__ */
